/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.migration.MigrationNamespaceSerializerProxy;
import org.apache.flink.runtime.state.KeyedBackendSerializationProxy;
import org.apache.flink.util.Preconditions;

public class RegisteredBackendStateMetaInfo<N, S> {
    private final StateDescriptor.Type stateType;
    private final String name;
    private final TypeSerializer<N> namespaceSerializer;
    private final TypeSerializer<S> stateSerializer;

    public RegisteredBackendStateMetaInfo(KeyedBackendSerializationProxy.StateMetaInfo<N, S> metaInfoProxy) {
        this(metaInfoProxy.getStateType(), metaInfoProxy.getStateName(), metaInfoProxy.getNamespaceSerializerSerializationProxy().getTypeSerializer(), metaInfoProxy.getStateSerializerSerializationProxy().getTypeSerializer());
    }

    public RegisteredBackendStateMetaInfo(StateDescriptor.Type stateType, String name, TypeSerializer<N> namespaceSerializer, TypeSerializer<S> stateSerializer) {
        this.stateType = (StateDescriptor.Type)Preconditions.checkNotNull((Object)stateType);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.namespaceSerializer = (TypeSerializer)Preconditions.checkNotNull(namespaceSerializer);
        this.stateSerializer = (TypeSerializer)Preconditions.checkNotNull(stateSerializer);
    }

    public StateDescriptor.Type getStateType() {
        return this.stateType;
    }

    public String getName() {
        return this.name;
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializer<S> getStateSerializer() {
        return this.stateSerializer;
    }

    public boolean isCompatibleWith(RegisteredBackendStateMetaInfo<?, ?> other) {
        if (this == other) {
            return true;
        }
        if (null == other) {
            return false;
        }
        if (!(this.stateType.equals((Object)StateDescriptor.Type.UNKNOWN) || other.stateType.equals((Object)StateDescriptor.Type.UNKNOWN) || this.stateType.equals((Object)other.stateType))) {
            return false;
        }
        if (!this.name.equals(other.getName())) {
            return false;
        }
        return this.stateSerializer.isCompatibleWith(other.stateSerializer) && (this.namespaceSerializer.isCompatibleWith(other.namespaceSerializer) || other.namespaceSerializer instanceof MigrationNamespaceSerializerProxy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredBackendStateMetaInfo that = (RegisteredBackendStateMetaInfo)o;
        if (!this.stateType.equals((Object)that.stateType)) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.getStateSerializer().equals(that.getStateSerializer()) && this.getNamespaceSerializer().equals(that.getNamespaceSerializer());
    }

    public String toString() {
        return "RegisteredBackendStateMetaInfo{stateType=" + this.stateType + ", name='" + this.name + '\'' + ", namespaceSerializer=" + this.namespaceSerializer + ", stateSerializer=" + this.stateSerializer + '}';
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getStateType().hashCode();
        result = 31 * result + (this.getNamespaceSerializer() != null ? this.getNamespaceSerializer().hashCode() : 0);
        result = 31 * result + (this.getStateSerializer() != null ? this.getStateSerializer().hashCode() : 0);
        return result;
    }
}

