/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStreamFactory;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsStateBackend
extends AbstractStateBackend {
    private static final long serialVersionUID = -8191916350224044011L;
    private static final Logger LOG = LoggerFactory.getLogger(FsStateBackend.class);
    public static final int DEFAULT_FILE_STATE_THRESHOLD = 1024;
    private static final int MAX_FILE_STATE_THRESHOLD = 0x100000;
    private final Path basePath;
    private final int fileStateThreshold;

    public FsStateBackend(String checkpointDataUri) throws IOException {
        this(new Path(checkpointDataUri));
    }

    public FsStateBackend(Path checkpointDataUri) throws IOException {
        this(checkpointDataUri.toUri());
    }

    public FsStateBackend(URI checkpointDataUri) throws IOException {
        this(checkpointDataUri, 1024);
    }

    public FsStateBackend(URI checkpointDataUri, int fileStateSizeThreshold) throws IOException {
        if (fileStateSizeThreshold < 0) {
            throw new IllegalArgumentException("The threshold for file state size must be zero or larger.");
        }
        if (fileStateSizeThreshold > 0x100000) {
            throw new IllegalArgumentException("The threshold for file state size cannot be larger than 1048576");
        }
        this.fileStateThreshold = fileStateSizeThreshold;
        this.basePath = FsStateBackend.validateAndNormalizeUri(checkpointDataUri);
    }

    public Path getBasePath() {
        return this.basePath;
    }

    @Override
    public CheckpointStreamFactory createStreamFactory(JobID jobId, String operatorIdentifier) throws IOException {
        return new FsCheckpointStreamFactory(this.basePath, jobId, this.fileStateThreshold);
    }

    @Override
    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry) throws Exception {
        return new HeapKeyedStateBackend<K>(kvStateRegistry, keySerializer, env.getUserClassLoader(), numberOfKeyGroups, keyGroupRange);
    }

    public String toString() {
        return "File State Backend @ " + this.basePath;
    }

    public static Path validateAndNormalizeUri(URI checkpointDataUri) throws IOException {
        String scheme = checkpointDataUri.getScheme();
        String path = checkpointDataUri.getPath();
        if (scheme == null) {
            throw new IllegalArgumentException("The scheme (hdfs://, file://, etc) is null. Please specify the file system scheme explicitly in the URI.");
        }
        if (path == null) {
            throw new IllegalArgumentException("The path to store the checkpoint data in is null. Please specify a directory path for the checkpoint data.");
        }
        if (path.length() == 0 || path.equals("/")) {
            throw new IllegalArgumentException("Cannot use the root directory for checkpoints.");
        }
        if (!FileSystem.isFlinkSupportedScheme((String)checkpointDataUri.getScheme())) {
            return new Path(checkpointDataUri);
        }
        FileSystem filesystem = FileSystem.get((URI)checkpointDataUri);
        if (filesystem == null) {
            String reason = "Could not find a file system for the given scheme inthe available configurations.";
            LOG.warn("Could not verify checkpoint path. This might be caused by a genuine problem or by the fact that the file system is not accessible from the client. Reason:{}", (Object)reason);
            return new Path(checkpointDataUri);
        }
        URI fsURI = filesystem.getUri();
        try {
            URI baseURI = new URI(fsURI.getScheme(), fsURI.getAuthority(), path, null, null);
            return new Path(baseURI);
        }
        catch (URISyntaxException e) {
            String reason = String.format("Cannot create file system URI for checkpointDataUri %s and filesystem URI %s: " + e.toString(), checkpointDataUri, fsURI);
            LOG.warn("Could not verify checkpoint path. This might be caused by a genuine problem or by the fact that the file system is not accessible from the client. Reason: {}", (Object)reason);
            return new Path(checkpointDataUri);
        }
    }
}

