/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.heap.AbstractHeapState;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.util.Preconditions;

public class HeapListState<K, N, V>
extends AbstractHeapState<K, N, ArrayList<V>, ListState<V>, ListStateDescriptor<V>>
implements ListState<V> {
    public HeapListState(KeyedStateBackend<K> backend, ListStateDescriptor<V> stateDesc, StateTable<K, N, ArrayList<V>> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
        super(backend, stateDesc, stateTable, keySerializer, namespaceSerializer);
    }

    public Iterable<V> get() {
        Preconditions.checkState((this.currentNamespace != null ? 1 : 0) != 0, (Object)"No namespace set.");
        Preconditions.checkState((this.backend.getCurrentKey() != null ? 1 : 0) != 0, (Object)"No key set.");
        Map namespaceMap = this.stateTable.get(this.backend.getCurrentKeyGroupIndex());
        if (namespaceMap == null) {
            return null;
        }
        Map keyedMap = namespaceMap.get(this.currentNamespace);
        if (keyedMap == null) {
            return null;
        }
        return (Iterable)keyedMap.get(this.backend.getCurrentKey());
    }

    public void add(V value) {
        ArrayList<V> list;
        Map<Object, Object> keyedMap;
        Preconditions.checkState((this.currentNamespace != null ? 1 : 0) != 0, (Object)"No namespace set.");
        Preconditions.checkState((this.backend.getCurrentKey() != null ? 1 : 0) != 0, (Object)"No key set.");
        if (value == null) {
            this.clear();
            return;
        }
        Map namespaceMap = this.stateTable.get(this.backend.getCurrentKeyGroupIndex());
        if (namespaceMap == null) {
            namespaceMap = this.createNewMap();
            this.stateTable.set(this.backend.getCurrentKeyGroupIndex(), namespaceMap);
        }
        if ((keyedMap = namespaceMap.get(this.currentNamespace)) == null) {
            keyedMap = this.createNewMap();
            namespaceMap.put(this.currentNamespace, keyedMap);
        }
        if ((list = (ArrayList<V>)keyedMap.get(this.backend.getCurrentKey())) == null) {
            list = new ArrayList<V>();
            keyedMap.put(this.backend.getCurrentKey(), list);
        }
        list.add(value);
    }

    @Override
    public byte[] getSerializedValue(K key, N namespace) throws Exception {
        Preconditions.checkState((namespace != null ? 1 : 0) != 0, (Object)"No namespace given.");
        Preconditions.checkState((key != null ? 1 : 0) != 0, (Object)"No key given.");
        Map namespaceMap = this.stateTable.get(KeyGroupRangeAssignment.assignToKeyGroup(key, this.backend.getNumberOfKeyGroups()));
        if (namespaceMap == null) {
            return null;
        }
        Map keyedMap = namespaceMap.get(this.currentNamespace);
        if (keyedMap == null) {
            return null;
        }
        ArrayList result = (ArrayList)keyedMap.get(key);
        if (result == null) {
            return null;
        }
        TypeSerializer serializer = ((ListStateDescriptor)this.stateDesc).getSerializer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)baos);
        for (int i = 0; i < result.size(); ++i) {
            serializer.serialize(result.get(i), (DataOutputView)view);
            if (i >= result.size() - 1) continue;
            view.writeByte(44);
        }
        view.flush();
        return baos.toByteArray();
    }
}

