/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Map;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.heap.AbstractHeapState;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.util.Preconditions;

public class HeapValueState<K, N, V>
extends AbstractHeapState<K, N, V, ValueState<V>, ValueStateDescriptor<V>>
implements ValueState<V> {
    public HeapValueState(KeyedStateBackend<K> backend, ValueStateDescriptor<V> stateDesc, StateTable<K, N, V> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
        super(backend, stateDesc, stateTable, keySerializer, namespaceSerializer);
    }

    public V value() {
        Preconditions.checkState((this.currentNamespace != null ? 1 : 0) != 0, (Object)"No namespace set.");
        Preconditions.checkState((this.backend.getCurrentKey() != null ? 1 : 0) != 0, (Object)"No key set.");
        Map namespaceMap = this.stateTable.get(this.backend.getCurrentKeyGroupIndex());
        if (namespaceMap == null) {
            return (V)((ValueStateDescriptor)this.stateDesc).getDefaultValue();
        }
        Map keyedMap = namespaceMap.get(this.currentNamespace);
        if (keyedMap == null) {
            return (V)((ValueStateDescriptor)this.stateDesc).getDefaultValue();
        }
        Object result = keyedMap.get(this.backend.getCurrentKey());
        if (result == null) {
            return (V)((ValueStateDescriptor)this.stateDesc).getDefaultValue();
        }
        return (V)result;
    }

    public void update(V value) {
        Map<Object, Object> keyedMap;
        Preconditions.checkState((this.currentNamespace != null ? 1 : 0) != 0, (Object)"No namespace set.");
        Preconditions.checkState((this.backend.getCurrentKey() != null ? 1 : 0) != 0, (Object)"No key set.");
        if (value == null) {
            this.clear();
            return;
        }
        Map namespaceMap = this.stateTable.get(this.backend.getCurrentKeyGroupIndex());
        if (namespaceMap == null) {
            namespaceMap = this.createNewMap();
            this.stateTable.set(this.backend.getCurrentKeyGroupIndex(), namespaceMap);
        }
        if ((keyedMap = namespaceMap.get(this.currentNamespace)) == null) {
            keyedMap = this.createNewMap();
            namespaceMap.put(this.currentNamespace, keyedMap);
        }
        keyedMap.put(this.backend.getCurrentKey(), value);
    }
}

