/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public class ByteStreamStateHandle
implements StreamStateHandle {
    private static final long serialVersionUID = -5280226231202517594L;
    private final byte[] data;
    private final String handleName;

    public ByteStreamStateHandle(String handleName, byte[] data) {
        this.handleName = (String)Preconditions.checkNotNull((Object)handleName);
        this.data = (byte[])Preconditions.checkNotNull((Object)data);
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        return new ByteStateHandleInputStream(this.data);
    }

    @Override
    public Optional<byte[]> asBytesIfInMemory() {
        return Optional.of(this.getData());
    }

    public byte[] getData() {
        return this.data;
    }

    public String getHandleName() {
        return this.handleName;
    }

    @Override
    public void discardState() {
    }

    @Override
    public long getStateSize() {
        return this.data.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteStreamStateHandle)) {
            return false;
        }
        ByteStreamStateHandle that = (ByteStreamStateHandle)o;
        return this.handleName.equals(that.handleName);
    }

    public int hashCode() {
        return 31 * this.handleName.hashCode();
    }

    public String toString() {
        return "ByteStreamStateHandle{handleName='" + this.handleName + '\'' + ", dataBytes=" + this.data.length + '}';
    }

    private static final class ByteStateHandleInputStream
    extends FSDataInputStream {
        private final byte[] data;
        private int index;

        public ByteStateHandleInputStream(byte[] data) {
            this.data = data;
        }

        public void seek(long desired) throws IOException {
            if (desired < 0L || desired > (long)this.data.length) {
                throw new IOException("position out of bounds");
            }
            this.index = (int)desired;
        }

        public long getPos() throws IOException {
            return this.index;
        }

        public int read() throws IOException {
            return this.index < this.data.length ? this.data[this.index++] & 0xFF : -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int bytesLeft = this.data.length - this.index;
            if (bytesLeft > 0) {
                int bytesToCopy = Math.min(len, bytesLeft);
                System.arraycopy(this.data, this.index, b, off, bytesToCopy);
                this.index += bytesToCopy;
                return bytesToCopy;
            }
            return -1;
        }
    }
}

