/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.StateFactory;
import org.apache.flink.runtime.scheduler.adaptive.StateWithExecutionGraph;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

class Failing
extends StateWithExecutionGraph {
    private final Context context;

    Failing(Context context, ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, Logger logger, Throwable failureCause) {
        super(context, executionGraph, executionGraphHandler, operatorCoordinatorHandler, logger);
        this.context = context;
        this.getExecutionGraph().failJob(failureCause, System.currentTimeMillis());
    }

    @Override
    public JobStatus getJobStatus() {
        return JobStatus.FAILING;
    }

    @Override
    public void cancel() {
        this.context.goToCanceling(this.getExecutionGraph(), this.getExecutionGraphHandler(), this.getOperatorCoordinatorHandler());
    }

    @Override
    public void handleGlobalFailure(Throwable cause) {
    }

    @Override
    boolean updateTaskExecutionState(TaskExecutionStateTransition taskExecutionStateTransition) {
        return this.getExecutionGraph().updateState(taskExecutionStateTransition);
    }

    @Override
    void onGloballyTerminalState(JobStatus globallyTerminalState) {
        Preconditions.checkState((globallyTerminalState == JobStatus.FAILED ? 1 : 0) != 0);
        this.context.goToFinished(ArchivedExecutionGraph.createFrom(this.getExecutionGraph()));
    }

    static class Factory
    implements StateFactory<Failing> {
        private final Context context;
        private final Logger log;
        private final ExecutionGraph executionGraph;
        private final ExecutionGraphHandler executionGraphHandler;
        private final OperatorCoordinatorHandler operatorCoordinatorHandler;
        private final Throwable failureCause;

        public Factory(Context context, ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, Logger log, Throwable failureCause) {
            this.context = context;
            this.log = log;
            this.executionGraph = executionGraph;
            this.executionGraphHandler = executionGraphHandler;
            this.operatorCoordinatorHandler = operatorCoordinatorHandler;
            this.failureCause = failureCause;
        }

        @Override
        public Class<Failing> getStateClass() {
            return Failing.class;
        }

        @Override
        public Failing getState() {
            return new Failing(this.context, this.executionGraph, this.executionGraphHandler, this.operatorCoordinatorHandler, this.log, this.failureCause);
        }
    }

    static interface Context
    extends StateWithExecutionGraph.Context {
        public void goToCanceling(ExecutionGraph var1, ExecutionGraphHandler var2, OperatorCoordinatorHandler var3);
    }
}

