/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.history;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HistoryServerOptions;
import org.apache.flink.runtime.net.SSLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HistoryServerUtils {

    private static final Logger LOG = LoggerFactory.getLogger(HistoryServerUtils.class);

    public static boolean isSSLEnabled(Configuration config) {
        return config.getBoolean(HistoryServerOptions.HISTORY_SERVER_WEB_SSL_ENABLED) && SSLUtils.isRestSSLEnabled(config);
    }

    public static Optional<URL> getHistoryServerURL(Configuration configuration) {
        String hostname = HistoryServerUtils.getHostname(configuration);
        if (hostname != null) {
            String protocol = HistoryServerUtils.getProtocol(configuration);
            int port = HistoryServerUtils.getPort(configuration);
            try {
                return Optional.of(new URL(protocol, hostname, port, ""));
            }
            catch (MalformedURLException e) {
                LOG.debug("Could not create the HistoryServer's URL from protocol: {}, hostname: {} and port: {}.", new Object[]{protocol, hostname, port, e});
                return Optional.empty();
            }
        }
        LOG.debug("Not hostname has been specified for the HistoryServer. This indicates that it has not been started.");
        return Optional.empty();
    }

    private static int getPort(Configuration configuration) {
        return configuration.getInteger(HistoryServerOptions.HISTORY_SERVER_WEB_PORT);
    }

    @Nullable
    private static String getHostname(Configuration configuration) {
        return configuration.getString(HistoryServerOptions.HISTORY_SERVER_WEB_ADDRESS);
    }

    private static String getProtocol(Configuration configuration) {
        if (HistoryServerUtils.isSSLEnabled(configuration)) {
            return "https";
        }
        return "http";
    }
}

