/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.netty4.io.netty.handler.ssl;

import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufInputStream;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.ApplicationProtocolConfig;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.OpenSsl;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.OpenSslContext;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.OpenSslEngine;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.OpenSslEngineMap;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.OpenSslSessionContext;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.PemReader;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;

public final class OpenSslClientContext
extends OpenSslContext {
    private final OpenSslSessionContext sessionContext;
    private final OpenSslEngineMap engineMap;

    public OpenSslClientContext() throws SSLException {
        this(null, null, null, null, 0L, 0L);
    }

    public OpenSslClientContext(File certChainFile) throws SSLException {
        this(certChainFile, null);
    }

    public OpenSslClientContext(TrustManagerFactory trustManagerFactory) throws SSLException {
        this(null, trustManagerFactory);
    }

    public OpenSslClientContext(File certChainFile, TrustManagerFactory trustManagerFactory) throws SSLException {
        this(certChainFile, trustManagerFactory, null, null, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSslClientContext(File certChainFile, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        super(ciphers, apn, sessionCacheSize, sessionTimeout, 0);
        boolean success = false;
        try {
            if (certChainFile != null && !certChainFile.isFile()) {
                throw new IllegalArgumentException("certChainFile is not a file: " + certChainFile);
            }
            Class<OpenSslContext> clazz = OpenSslContext.class;
            synchronized (OpenSslContext.class) {
                long error;
                if (certChainFile != null && !SSLContext.setCertificateChainFile((long)this.ctx, (String)certChainFile.getPath(), (boolean)true) && OpenSsl.isError(error = (long)SSL.getLastErrorNumber())) {
                    throw new SSLException("failed to set certificate chain: " + certChainFile + " (" + SSL.getErrorString((long)error) + ')');
                }
                SSLContext.setVerify((long)this.ctx, (int)0, (int)10);
                try {
                    if (trustManagerFactory == null) {
                        trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    }
                    OpenSslClientContext.initTrustManagerFactory(certChainFile, trustManagerFactory);
                    final X509TrustManager manager = OpenSslClientContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
                    this.engineMap = OpenSslClientContext.newEngineMap(manager);
                    if (OpenSslClientContext.useExtendedTrustManager(manager)) {
                        final X509ExtendedTrustManager extendedManager = (X509ExtendedTrustManager)manager;
                        SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new OpenSslContext.AbstractCertificateVerifier(){

                            @Override
                            void verify(long ssl, X509Certificate[] peerCerts, String auth) throws Exception {
                                OpenSslEngine engine = OpenSslClientContext.this.engineMap.remove(ssl);
                                extendedManager.checkServerTrusted(peerCerts, auth, engine);
                            }
                        });
                    } else {
                        SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new OpenSslContext.AbstractCertificateVerifier(){

                            @Override
                            void verify(long ssl, X509Certificate[] peerCerts, String auth) throws Exception {
                                manager.checkServerTrusted(peerCerts, auth);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    throw new SSLException("unable to setup trustmanager", e);
                }
                this.sessionContext = new OpenSslClientSessionContext(this.ctx);
                success = true;
            }
        }
        finally {
            if (!success) {
                this.destroyPools();
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTrustManagerFactory(File certChainFile, TrustManagerFactory trustManagerFactory) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        if (certChainFile != null) {
            ByteBuf[] certs = PemReader.readCertificates(certChainFile);
            try {
                for (ByteBuf buf : certs) {
                    X509Certificate cert = (X509Certificate)X509_CERT_FACTORY.generateCertificate(new ByteBufInputStream(buf));
                    X500Principal principal = cert.getSubjectX500Principal();
                    ks.setCertificateEntry(principal.getName("RFC2253"), cert);
                }
            }
            finally {
                for (ByteBuf buf : certs) {
                    buf.release();
                }
            }
        }
        trustManagerFactory.init(ks);
    }

    @Override
    public OpenSslSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    OpenSslEngineMap engineMap() {
        return this.engineMap;
    }

    private static final class OpenSslClientSessionContext
    extends OpenSslSessionContext {
        private OpenSslClientSessionContext(long context) {
            super(context);
        }

        @Override
        public void setSessionTimeout(int seconds) {
            if (seconds < 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public int getSessionTimeout() {
            return 0;
        }

        @Override
        public void setSessionCacheSize(int size) {
            if (size < 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public int getSessionCacheSize() {
            return 0;
        }

        @Override
        public void setSessionCacheEnabled(boolean enabled) {
        }

        @Override
        public boolean isSessionCacheEnabled() {
            return false;
        }
    }
}

