/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlAlterTableOptions;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;

public abstract class SqlAlterHiveTable
extends SqlAlterTableOptions {
    public static final String ALTER_TABLE_OP = "alter.table.op";
    public static final String ALTER_COL_CASCADE = "alter.column.cascade";

    public SqlAlterHiveTable(AlterTableOp op, SqlParserPos pos, SqlIdentifier tableName, SqlNodeList partSpec, SqlNodeList propertyList) {
        super(pos, tableName, partSpec, propertyList);
        propertyList.add((SqlNode)HiveDDLUtils.toTableOption(ALTER_TABLE_OP, op.name(), pos));
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER TABLE");
        this.tableIdentifier.unparse(writer, leftPrec, rightPrec);
        SqlNodeList partitionSpec = this.getPartitionSpec();
        if (partitionSpec != null && partitionSpec.size() > 0) {
            writer.keyword("PARTITION");
            partitionSpec.unparse(writer, this.getOperator().getLeftPrec(), this.getOperator().getRightPrec());
        }
    }

    public static enum AlterTableOp {
        CHANGE_TBL_PROPS,
        CHANGE_SERDE_PROPS,
        CHANGE_FILE_FORMAT,
        CHANGE_LOCATION,
        ALTER_COLUMNS;

    }
}

