/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.io.IOException;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.streaming.runtime.io.checkpointing.AlternatingWaitingForFirstBarrier;
import org.apache.flink.streaming.runtime.io.checkpointing.BarrierHandlerState;
import org.apache.flink.streaming.runtime.io.checkpointing.ChannelState;

abstract class AbstractAlternatingAlignedBarrierHandlerState
implements BarrierHandlerState {
    protected final ChannelState state;

    protected AbstractAlternatingAlignedBarrierHandlerState(ChannelState state) {
        this.state = state;
    }

    @Override
    public final BarrierHandlerState announcementReceived(BarrierHandlerState.Controller controller, InputChannelInfo channelInfo, int sequenceNumber) {
        this.state.addSeenAnnouncement(channelInfo, sequenceNumber);
        return this;
    }

    @Override
    public final BarrierHandlerState barrierReceived(BarrierHandlerState.Controller controller, InputChannelInfo channelInfo, CheckpointBarrier checkpointBarrier, boolean markChannelBlocked) throws IOException, CheckpointException {
        if (checkpointBarrier.getCheckpointOptions().isUnalignedCheckpoint()) {
            BarrierHandlerState unalignedState = this.alignmentTimeout(controller, checkpointBarrier);
            return unalignedState.barrierReceived(controller, channelInfo, checkpointBarrier, markChannelBlocked);
        }
        this.state.removeSeenAnnouncement(channelInfo);
        if (markChannelBlocked) {
            this.state.blockChannel(channelInfo);
        }
        if (controller.allBarriersReceived()) {
            controller.initInputsCheckpoint(checkpointBarrier);
            controller.triggerGlobalCheckpoint(checkpointBarrier);
            return this.finishCheckpoint();
        }
        if (controller.isTimedOut(checkpointBarrier)) {
            return this.alignmentTimeout(controller, checkpointBarrier).barrierReceived(controller, channelInfo, checkpointBarrier.asUnaligned(), markChannelBlocked);
        }
        return this.transitionAfterBarrierReceived(this.state);
    }

    protected abstract BarrierHandlerState transitionAfterBarrierReceived(ChannelState var1);

    @Override
    public final BarrierHandlerState abort(long cancelledId) throws IOException {
        return this.finishCheckpoint();
    }

    protected BarrierHandlerState finishCheckpoint() throws IOException {
        this.state.unblockAllChannels();
        return new AlternatingWaitingForFirstBarrier(this.state.emptyState());
    }
}

