/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.datastream.CustomSinkOperatorUidHashes;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.util.Preconditions;

@Internal
public class SinkTransformation<InputT, OutputT>
extends PhysicalTransformation<OutputT> {
    private final DataStream<InputT> inputStream;
    private final Sink<InputT> sink;
    private final Transformation<InputT> input;
    private final CustomSinkOperatorUidHashes customSinkOperatorUidHashes;
    private ChainingStrategy chainingStrategy;

    public SinkTransformation(DataStream<InputT> inputStream, Sink<InputT> sink, TypeInformation<OutputT> outputType, String name, int parallelism, boolean parallelismConfigured, CustomSinkOperatorUidHashes customSinkOperatorUidHashes) {
        super(name, outputType, parallelism, parallelismConfigured);
        this.inputStream = (DataStream)Preconditions.checkNotNull(inputStream);
        this.sink = (Sink)Preconditions.checkNotNull(sink);
        this.input = inputStream.getTransformation();
        this.customSinkOperatorUidHashes = (CustomSinkOperatorUidHashes)Preconditions.checkNotNull((Object)customSinkOperatorUidHashes);
    }

    @Override
    public void setChainingStrategy(ChainingStrategy strategy) {
        this.chainingStrategy = (ChainingStrategy)((Object)Preconditions.checkNotNull((Object)((Object)strategy)));
    }

    public List<Transformation<?>> getTransitivePredecessors() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    public List<Transformation<?>> getInputs() {
        return Collections.singletonList(this.input);
    }

    @Nullable
    public ChainingStrategy getChainingStrategy() {
        return this.chainingStrategy;
    }

    public DataStream<InputT> getInputStream() {
        return this.inputStream;
    }

    public Sink<InputT> getSink() {
        return this.sink;
    }

    public CustomSinkOperatorUidHashes getSinkOperatorsUidHashes() {
        return this.customSinkOperatorUidHashes;
    }
}

