/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sort;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.io.StreamTaskInput;

class ObservableStreamTaskInput<T>
implements StreamTaskInput<T> {
    private final StreamTaskInput<T> wrappedInput;
    private final BoundedMultiInput endOfInputObserver;

    public ObservableStreamTaskInput(StreamTaskInput<T> wrappedInput, BoundedMultiInput endOfInputObserver) {
        this.wrappedInput = wrappedInput;
        this.endOfInputObserver = endOfInputObserver;
    }

    @Override
    public InputStatus emitNext(PushingAsyncDataInput.DataOutput<T> output) throws Exception {
        InputStatus result = this.wrappedInput.emitNext(output);
        if (result == InputStatus.END_OF_INPUT) {
            this.endOfInputObserver.endInput(this.wrappedInput.getInputIndex());
        }
        return result;
    }

    @Override
    public int getInputIndex() {
        return this.wrappedInput.getInputIndex();
    }

    @Override
    public CompletableFuture<Void> prepareSnapshot(ChannelStateWriter channelStateWriter, long checkpointId) throws IOException {
        return this.wrappedInput.prepareSnapshot(channelStateWriter, checkpointId);
    }

    @Override
    public void close() throws IOException {
        this.wrappedInput.close();
    }

    public CompletableFuture<?> getAvailableFuture() {
        return this.wrappedInput.getAvailableFuture();
    }

    public boolean isAvailable() {
        return this.wrappedInput.isAvailable();
    }
}

