/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetricsBuilder;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.SequentialChannelStateReader;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;
import org.apache.flink.runtime.io.network.api.writer.MultipleRecordWriters;
import org.apache.flink.runtime.io.network.api.writer.NonRecordWriter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriterBuilder;
import org.apache.flink.runtime.io.network.api.writer.RecordWriterDelegate;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.api.writer.SingleRecordWriter;
import org.apache.flink.runtime.io.network.partition.ChannelStateHolder;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.runtime.state.CheckpointStorageWorkerView;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateBackendLoader;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.taskmanager.DispatcherThreadFactory;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.FatalExitExceptionHandler;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManagerImpl;
import org.apache.flink.streaming.api.operators.MailboxExecutor;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializer;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializerImpl;
import org.apache.flink.streaming.runtime.io.RecordWriterOutput;
import org.apache.flink.streaming.runtime.io.StreamInputProcessor;
import org.apache.flink.streaming.runtime.partitioner.ConfigurableStreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.AsyncExceptionHandler;
import org.apache.flink.streaming.runtime.tasks.AsynchronousException;
import org.apache.flink.streaming.runtime.tasks.OperatorChain;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeCallback;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeServiceFactory;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeServiceImpl;
import org.apache.flink.streaming.runtime.tasks.StreamOperatorWrapper;
import org.apache.flink.streaming.runtime.tasks.StreamTaskActionExecutor;
import org.apache.flink.streaming.runtime.tasks.SubtaskCheckpointCoordinator;
import org.apache.flink.streaming.runtime.tasks.SubtaskCheckpointCoordinatorImpl;
import org.apache.flink.streaming.runtime.tasks.SystemProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TimerException;
import org.apache.flink.streaming.runtime.tasks.TimerService;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxDefaultAction;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxExecutorFactory;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxProcessor;
import org.apache.flink.streaming.runtime.tasks.mailbox.TaskMailbox;
import org.apache.flink.streaming.runtime.tasks.mailbox.TaskMailboxImpl;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.RunnableWithException;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class StreamTask<OUT, OP extends StreamOperator<OUT>>
extends AbstractInvokable
implements AsyncExceptionHandler {
    public static final ThreadGroup TRIGGER_THREAD_GROUP = new ThreadGroup("Triggers");
    protected static final Logger LOG = LoggerFactory.getLogger(StreamTask.class);
    private final StreamTaskActionExecutor actionExecutor;
    @Nullable
    protected StreamInputProcessor inputProcessor;
    protected OP mainOperator;
    protected OperatorChain<OUT, OP> operatorChain;
    protected final StreamConfig configuration;
    protected final StateBackend stateBackend;
    private final SubtaskCheckpointCoordinator subtaskCheckpointCoordinator;
    protected final TimerService timerService;
    private final CloseableRegistry cancelables = new CloseableRegistry();
    private final StreamTaskAsyncExceptionHandler asyncExceptionHandler;
    private volatile boolean isRunning;
    private volatile boolean canceled;
    private volatile boolean failing;
    private boolean disposedOperators;
    private final ExecutorService asyncOperationsThreadPool;
    private final RecordWriterDelegate<SerializationDelegate<StreamRecord<OUT>>> recordWriter;
    protected final MailboxProcessor mailboxProcessor;
    final MailboxExecutor mainMailboxExecutor;
    private final ExecutorService channelIOExecutor;
    private Long syncSavepointId = null;
    private Long activeSyncSavepointId = null;
    private long latestAsyncCheckpointStartDelayNanos;

    protected StreamTask(Environment env) throws Exception {
        this(env, null);
    }

    protected StreamTask(Environment env, @Nullable TimerService timerService) throws Exception {
        this(env, timerService, (Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE);
    }

    protected StreamTask(Environment environment, @Nullable TimerService timerService, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) throws Exception {
        this(environment, timerService, uncaughtExceptionHandler, StreamTaskActionExecutor.IMMEDIATE);
    }

    protected StreamTask(Environment environment, @Nullable TimerService timerService, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, StreamTaskActionExecutor actionExecutor) throws Exception {
        this(environment, timerService, uncaughtExceptionHandler, actionExecutor, new TaskMailboxImpl(Thread.currentThread()));
    }

    protected StreamTask(Environment environment, @Nullable TimerService timerService, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, StreamTaskActionExecutor actionExecutor, TaskMailbox mailbox) throws Exception {
        super(environment);
        this.configuration = new StreamConfig(this.getTaskConfiguration());
        this.recordWriter = StreamTask.createRecordWriterDelegate(this.configuration, environment);
        this.actionExecutor = (StreamTaskActionExecutor)Preconditions.checkNotNull((Object)actionExecutor);
        this.mailboxProcessor = new MailboxProcessor(this::processInput, mailbox, actionExecutor);
        this.mailboxProcessor.initMetric(environment.getMetricGroup());
        this.mainMailboxExecutor = this.mailboxProcessor.getMainMailboxExecutor();
        this.asyncExceptionHandler = new StreamTaskAsyncExceptionHandler(environment);
        this.asyncOperationsThreadPool = Executors.newCachedThreadPool((ThreadFactory)new ExecutorThreadFactory("AsyncOperations", uncaughtExceptionHandler));
        this.stateBackend = this.createStateBackend();
        this.subtaskCheckpointCoordinator = new SubtaskCheckpointCoordinatorImpl((CheckpointStorageWorkerView)this.stateBackend.createCheckpointStorage(this.getEnvironment().getJobID()), this.getName(), actionExecutor, this.getCancelables(), this.getAsyncOperationsThreadPool(), this.getEnvironment(), this, this.configuration.isUnalignedCheckpointsEnabled(), (BiFunctionWithException<ChannelStateWriter, Long, CompletableFuture<Void>, IOException>)((BiFunctionWithException)this::prepareInputSnapshot));
        if (timerService == null) {
            DispatcherThreadFactory timerThreadFactory = new DispatcherThreadFactory(TRIGGER_THREAD_GROUP, "Time Trigger for " + this.getName());
            this.timerService = new SystemProcessingTimeService(this::handleTimerException, (ThreadFactory)timerThreadFactory);
        } else {
            this.timerService = timerService;
        }
        this.channelIOExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new ExecutorThreadFactory("channel-state-unspilling"));
        this.injectChannelStateWriterIntoChannels();
    }

    private void injectChannelStateWriterIntoChannels() {
        Environment env = this.getEnvironment();
        ChannelStateWriter channelStateWriter = this.subtaskCheckpointCoordinator.getChannelStateWriter();
        for (IndexedInputGate indexedInputGate : env.getAllInputGates()) {
            indexedInputGate.setChannelStateWriter(channelStateWriter);
        }
        for (IndexedInputGate indexedInputGate : env.getAllWriters()) {
            if (!(indexedInputGate instanceof ChannelStateHolder)) continue;
            ((ChannelStateHolder)indexedInputGate).setChannelStateWriter(channelStateWriter);
        }
    }

    private CompletableFuture<Void> prepareInputSnapshot(ChannelStateWriter channelStateWriter, long checkpointId) throws IOException {
        if (this.inputProcessor == null) {
            return FutureUtils.completedVoidFuture();
        }
        return this.inputProcessor.prepareSnapshot(channelStateWriter, checkpointId);
    }

    SubtaskCheckpointCoordinator getCheckpointCoordinator() {
        return this.subtaskCheckpointCoordinator;
    }

    protected abstract void init() throws Exception;

    protected void cancelTask() throws Exception {
    }

    protected void cleanup() throws Exception {
        if (this.inputProcessor != null) {
            this.inputProcessor.close();
        }
    }

    protected void processInput(MailboxDefaultAction.Controller controller) throws Exception {
        InputStatus status = this.inputProcessor.processInput();
        if (status == InputStatus.MORE_AVAILABLE && this.recordWriter.isAvailable()) {
            return;
        }
        if (status == InputStatus.END_OF_INPUT) {
            controller.allActionsCompleted();
            return;
        }
        CompletableFuture<?> jointFuture = this.getInputOutputJointFuture(status);
        MailboxDefaultAction.Suspension suspendedDefaultAction = controller.suspendDefaultAction();
        FutureUtils.assertNoException((CompletableFuture)jointFuture.thenRun(suspendedDefaultAction::resume));
    }

    @VisibleForTesting
    CompletableFuture<?> getInputOutputJointFuture(InputStatus status) {
        if (status == InputStatus.NOTHING_AVAILABLE && !this.recordWriter.isAvailable()) {
            return CompletableFuture.allOf(this.inputProcessor.getAvailableFuture(), this.recordWriter.getAvailableFuture());
        }
        if (status == InputStatus.NOTHING_AVAILABLE) {
            return this.inputProcessor.getAvailableFuture();
        }
        return this.recordWriter.getAvailableFuture();
    }

    private void resetSynchronousSavepointId(long id, boolean succeeded) {
        if (!succeeded && this.activeSyncSavepointId != null && this.activeSyncSavepointId == id) {
            this.activeSyncSavepointId = null;
            this.operatorChain.setIgnoreEndOfInput(false);
        }
        this.syncSavepointId = null;
    }

    private void setSynchronousSavepointId(long checkpointId, boolean ignoreEndOfInput) {
        Preconditions.checkState((this.syncSavepointId == null ? 1 : 0) != 0, (Object)"at most one stop-with-savepoint checkpoint at a time is allowed");
        this.syncSavepointId = checkpointId;
        this.activeSyncSavepointId = checkpointId;
        this.operatorChain.setIgnoreEndOfInput(ignoreEndOfInput);
    }

    @VisibleForTesting
    OptionalLong getSynchronousSavepointId() {
        return this.syncSavepointId != null ? OptionalLong.of(this.syncSavepointId) : OptionalLong.empty();
    }

    private boolean isSynchronousSavepointId(long checkpointId) {
        return this.syncSavepointId != null && this.syncSavepointId == checkpointId;
    }

    private void runSynchronousSavepointMailboxLoop() throws Exception {
        assert (this.syncSavepointId != null);
        MailboxExecutor mailboxExecutor = this.mailboxProcessor.getMailboxExecutor(Integer.MAX_VALUE);
        while (!this.canceled && this.syncSavepointId != null) {
            mailboxExecutor.yield();
        }
    }

    protected void advanceToEndOfEventTime() throws Exception {
    }

    protected void finishTask() throws Exception {
    }

    public StreamTaskStateInitializer createStreamTaskStateInitializer() {
        InternalTimeServiceManager.Provider timerServiceProvider = this.configuration.getTimerServiceProvider(this.getUserCodeClassLoader());
        return new StreamTaskStateInitializerImpl(this.getEnvironment(), this.stateBackend, TtlTimeProvider.DEFAULT, timerServiceProvider != null ? timerServiceProvider : InternalTimeServiceManagerImpl::create);
    }

    protected Counter setupNumRecordsInCounter(StreamOperator streamOperator) {
        try {
            return ((OperatorMetricGroup)streamOperator.getMetricGroup()).getIOMetricGroup().getNumRecordsInCounter();
        }
        catch (Exception e) {
            LOG.warn("An exception occurred during the metrics setup.", (Throwable)e);
            return new SimpleCounter();
        }
    }

    protected void beforeInvoke() throws Exception {
        this.disposedOperators = false;
        LOG.debug("Initializing {}.", (Object)this.getName());
        this.operatorChain = new OperatorChain(this, this.recordWriter);
        this.mainOperator = this.operatorChain.getMainOperator();
        this.init();
        if (this.canceled) {
            throw new CancelTaskException();
        }
        LOG.debug("Invoking {}", (Object)this.getName());
        this.actionExecutor.runThrowing(() -> {
            SequentialChannelStateReader reader = this.getEnvironment().getTaskStateManager().getSequentialChannelStateReader();
            reader.readOutputData(this.getEnvironment().getAllWriters(), false);
            this.operatorChain.initializeStateAndOpenOperators(this.createStreamTaskStateInitializer());
            this.channelIOExecutor.execute(() -> {
                try {
                    reader.readInputData((InputGate[])this.getEnvironment().getAllInputGates());
                }
                catch (Exception e) {
                    this.asyncExceptionHandler.handleAsyncException("Unable to read channel state", e);
                }
            });
            for (IndexedInputGate inputGate : this.getEnvironment().getAllInputGates()) {
                inputGate.getStateConsumedFuture().thenRun(() -> this.lambda$null$1((InputGate)inputGate));
            }
        });
        this.isRunning = true;
    }

    public final void invoke() throws Exception {
        try {
            this.beforeInvoke();
            if (this.canceled) {
                throw new CancelTaskException();
            }
            this.runMailboxLoop();
            if (this.canceled) {
                throw new CancelTaskException();
            }
            this.afterInvoke();
        }
        catch (Throwable invokeException) {
            this.failing = !this.canceled;
            try {
                this.cleanUpInvoke();
            }
            catch (Throwable cleanUpException) {
                Throwable throwable = ExceptionUtils.firstOrSuppressed((Throwable)cleanUpException, (Throwable)invokeException);
                ExceptionUtils.rethrowException((Throwable)throwable);
            }
            ExceptionUtils.rethrowException((Throwable)invokeException);
        }
        this.cleanUpInvoke();
    }

    @VisibleForTesting
    public boolean runMailboxStep() throws Exception {
        return this.mailboxProcessor.runMailboxStep();
    }

    @VisibleForTesting
    public boolean isMailboxLoopRunning() {
        return this.mailboxProcessor.isMailboxLoopRunning();
    }

    public void runMailboxLoop() throws Exception {
        this.mailboxProcessor.runMailboxLoop();
    }

    protected void afterInvoke() throws Exception {
        LOG.debug("Finished task {}", (Object)this.getName());
        ((CompletableFuture)this.getCompletionFuture().exceptionally(unused -> null)).join();
        CompletableFuture timersFinishedFuture = new CompletableFuture();
        this.operatorChain.closeOperators(this.actionExecutor);
        this.actionExecutor.runThrowing(() -> {
            FutureUtils.forward(this.timerService.quiesce(), (CompletableFuture)timersFinishedFuture);
            this.mailboxProcessor.prepareClose();
            this.isRunning = false;
        });
        this.mailboxProcessor.drain();
        timersFinishedFuture.get();
        LOG.debug("Closed operators for task {}", (Object)this.getName());
        this.operatorChain.flushOutputs();
        this.disposeAllOperators();
    }

    protected void cleanUpInvoke() throws Exception {
        ((CompletableFuture)this.getCompletionFuture().exceptionally(unused -> null)).join();
        this.isRunning = false;
        this.setShouldInterruptOnCancel(false);
        Thread.interrupted();
        Exception suppressedException = this.runAndSuppressThrowable(this::tryShutdownTimerService, null);
        suppressedException = this.runAndSuppressThrowable(() -> ((CloseableRegistry)this.cancelables).close(), suppressedException);
        suppressedException = this.runAndSuppressThrowable(this::shutdownAsyncThreads, suppressedException);
        suppressedException = this.runAndSuppressThrowable(this::cleanup, suppressedException);
        suppressedException = this.runAndSuppressThrowable(this::disposeAllOperators, suppressedException);
        suppressedException = this.runAndSuppressThrowable(this::releaseOutputResources, suppressedException);
        suppressedException = this.runAndSuppressThrowable(this.channelIOExecutor::shutdown, suppressedException);
        suppressedException = this.runAndSuppressThrowable(this.mailboxProcessor::close, suppressedException);
        if (suppressedException != null) {
            throw suppressedException;
        }
    }

    protected CompletableFuture<Void> getCompletionFuture() {
        return FutureUtils.completedVoidFuture();
    }

    public final void cancel() throws Exception {
        this.isRunning = false;
        this.canceled = true;
        try {
            this.cancelTask();
        }
        finally {
            this.getCompletionFuture().whenComplete((unusedResult, unusedError) -> {
                this.mailboxProcessor.allActionsCompleted();
                try {
                    this.cancelables.close();
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
    }

    public MailboxExecutorFactory getMailboxExecutorFactory() {
        return this.mailboxProcessor::getMailboxExecutor;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final boolean isCanceled() {
        return this.canceled;
    }

    public final boolean isFailing() {
        return this.failing;
    }

    private void shutdownAsyncThreads() throws Exception {
        if (!this.asyncOperationsThreadPool.isShutdown()) {
            this.asyncOperationsThreadPool.shutdownNow();
        }
    }

    private void releaseOutputResources() throws Exception {
        if (this.operatorChain != null) {
            this.actionExecutor.run(() -> this.operatorChain.releaseOutputs());
        } else {
            this.recordWriter.close();
        }
    }

    private Exception runAndSuppressThrowable(ThrowingRunnable<?> runnable, @Nullable Exception originalException) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            Exception e = t instanceof Exception ? (Exception)t : new Exception(t);
            return (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)originalException);
        }
        return originalException;
    }

    private void disposeAllOperators() throws Exception {
        if (this.operatorChain != null && !this.disposedOperators) {
            Exception disposalException = null;
            for (StreamOperatorWrapper<?, ?> operatorWrapper : this.operatorChain.getAllOperators(true)) {
                Object operator = operatorWrapper.getStreamOperator();
                try {
                    operator.dispose();
                }
                catch (Exception e) {
                    disposalException = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, disposalException);
                }
            }
            this.disposedOperators = true;
            if (disposalException != null) {
                throw disposalException;
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.timerService.isTerminated()) {
            LOG.info("Timer service is shutting down.");
            this.timerService.shutdownService();
        }
        this.cancelables.close();
    }

    boolean isSerializingTimestamps() {
        TimeCharacteristic tc = this.configuration.getTimeCharacteristic();
        return tc == TimeCharacteristic.EventTime | tc == TimeCharacteristic.IngestionTime;
    }

    public final String getName() {
        return this.getEnvironment().getTaskInfo().getTaskNameWithSubtasks();
    }

    String getTaskNameWithSubtaskAndId() {
        return this.getEnvironment().getTaskInfo().getTaskNameWithSubtasks() + " (" + this.getEnvironment().getExecutionId() + ')';
    }

    public CheckpointStorageWorkerView getCheckpointStorage() {
        return this.subtaskCheckpointCoordinator.getCheckpointStorage();
    }

    public StreamConfig getConfiguration() {
        return this.configuration;
    }

    public StreamStatusMaintainer getStreamStatusMaintainer() {
        return this.operatorChain;
    }

    RecordWriterOutput<?>[] getStreamOutputs() {
        return this.operatorChain.getStreamOutputs();
    }

    public Future<Boolean> triggerCheckpointAsync(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        this.mainMailboxExecutor.execute((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> {
            this.latestAsyncCheckpointStartDelayNanos = 1000000L * Math.max(0L, System.currentTimeMillis() - checkpointMetaData.getTimestamp());
            try {
                result.complete(this.triggerCheckpoint(checkpointMetaData, checkpointOptions));
            }
            catch (Exception ex) {
                result.completeExceptionally(ex);
                throw ex;
            }
        }), "checkpoint %s with %s", checkpointMetaData, checkpointOptions);
        return result;
    }

    private boolean triggerCheckpoint(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions) throws Exception {
        try {
            CheckpointMetricsBuilder checkpointMetrics = new CheckpointMetricsBuilder().setAlignmentDurationNanos(0L).setBytesProcessedDuringAlignment(0L);
            this.subtaskCheckpointCoordinator.initCheckpoint(checkpointMetaData.getCheckpointId(), checkpointOptions);
            boolean success = this.performCheckpoint(checkpointMetaData, checkpointOptions, checkpointMetrics);
            if (!success) {
                this.declineCheckpoint(checkpointMetaData.getCheckpointId());
            }
            return success;
        }
        catch (Exception e) {
            if (this.isRunning) {
                throw new Exception("Could not perform checkpoint " + checkpointMetaData.getCheckpointId() + " for operator " + this.getName() + '.', e);
            }
            LOG.debug("Could not perform checkpoint {} for operator {} while the invokable was not in state running.", new Object[]{checkpointMetaData.getCheckpointId(), this.getName(), e});
            return false;
        }
    }

    public void triggerCheckpointOnBarrier(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetricsBuilder checkpointMetrics) throws IOException {
        try {
            if (this.performCheckpoint(checkpointMetaData, checkpointOptions, checkpointMetrics) && this.isSynchronousSavepointId(checkpointMetaData.getCheckpointId())) {
                this.runSynchronousSavepointMailboxLoop();
            }
        }
        catch (CancelTaskException e) {
            LOG.info("Operator {} was cancelled while performing checkpoint {}.", (Object)this.getName(), (Object)checkpointMetaData.getCheckpointId());
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Could not perform checkpoint " + checkpointMetaData.getCheckpointId() + " for operator " + this.getName() + '.', e);
        }
    }

    public void abortCheckpointOnBarrier(long checkpointId, Throwable cause) throws IOException {
        this.resetSynchronousSavepointId(checkpointId, false);
        this.subtaskCheckpointCoordinator.abortCheckpointOnBarrier(checkpointId, cause, this.operatorChain);
    }

    private boolean performCheckpoint(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetricsBuilder checkpointMetrics) throws Exception {
        LOG.debug("Starting checkpoint ({}) {} on task {}", new Object[]{checkpointMetaData.getCheckpointId(), checkpointOptions.getCheckpointType(), this.getName()});
        if (this.isRunning) {
            this.actionExecutor.runThrowing(() -> {
                if (checkpointOptions.getCheckpointType().isSynchronous()) {
                    this.setSynchronousSavepointId(checkpointMetaData.getCheckpointId(), checkpointOptions.getCheckpointType().shouldIgnoreEndOfInput());
                    if (checkpointOptions.getCheckpointType().shouldAdvanceToEndOfTime()) {
                        this.advanceToEndOfEventTime();
                    }
                } else if (this.activeSyncSavepointId != null && this.activeSyncSavepointId < checkpointMetaData.getCheckpointId()) {
                    this.activeSyncSavepointId = null;
                    this.operatorChain.setIgnoreEndOfInput(false);
                }
                this.subtaskCheckpointCoordinator.checkpointState(checkpointMetaData, checkpointOptions, checkpointMetrics, this.operatorChain, this::isRunning);
            });
            return true;
        }
        this.actionExecutor.runThrowing(() -> {
            CancelCheckpointMarker message = new CancelCheckpointMarker(checkpointMetaData.getCheckpointId());
            this.recordWriter.broadcastEvent((AbstractEvent)message);
        });
        return false;
    }

    protected void declineCheckpoint(long checkpointId) {
        this.getEnvironment().declineCheckpoint(checkpointId, (Throwable)new CheckpointException("Task Name" + this.getName(), CheckpointFailureReason.CHECKPOINT_DECLINED_TASK_NOT_READY));
    }

    public final ExecutorService getAsyncOperationsThreadPool() {
        return this.asyncOperationsThreadPool;
    }

    public Future<Void> notifyCheckpointCompleteAsync(long checkpointId) {
        return this.notifyCheckpointOperation(() -> this.notifyCheckpointComplete(checkpointId), String.format("checkpoint %d complete", checkpointId));
    }

    public Future<Void> notifyCheckpointAbortAsync(long checkpointId) {
        return this.notifyCheckpointOperation(() -> {
            this.resetSynchronousSavepointId(checkpointId, false);
            this.subtaskCheckpointCoordinator.notifyCheckpointAborted(checkpointId, this.operatorChain, this::isRunning);
        }, String.format("checkpoint %d aborted", checkpointId));
    }

    private Future<Void> notifyCheckpointOperation(RunnableWithException runnable, String description) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.mailboxProcessor.getMailboxExecutor(Integer.MAX_VALUE).execute((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> {
            try {
                runnable.run();
            }
            catch (Exception ex) {
                result.completeExceptionally(ex);
                throw ex;
            }
            result.complete(null);
        }), description);
        return result;
    }

    private void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.subtaskCheckpointCoordinator.notifyCheckpointComplete(checkpointId, this.operatorChain, this::isRunning);
        if (this.isRunning && this.isSynchronousSavepointId(checkpointId)) {
            this.finishTask();
            this.resetSynchronousSavepointId(checkpointId, true);
        }
    }

    private void tryShutdownTimerService() {
        long timeoutMs;
        if (!this.timerService.isTerminated() && !this.timerService.shutdownServiceUninterruptible(timeoutMs = this.getEnvironment().getTaskManagerInfo().getConfiguration().getLong(TaskManagerOptions.TASK_CANCELLATION_TIMEOUT_TIMERS))) {
            LOG.warn("Timer service shutdown exceeded time limit of {} ms while waiting for pending timers. Will continue with shutdown procedure.", (Object)timeoutMs);
        }
    }

    public void dispatchOperatorEvent(OperatorID operator, SerializedValue<OperatorEvent> event) throws FlinkException {
        try {
            this.mainMailboxExecutor.execute((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> this.operatorChain.dispatchOperatorEvent(operator, event)), "dispatch operator event");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private StateBackend createStateBackend() throws Exception {
        StateBackend fromApplication = this.configuration.getStateBackend(this.getUserCodeClassLoader());
        return StateBackendLoader.fromApplicationOrConfigOrDefault((StateBackend)fromApplication, (Configuration)this.getEnvironment().getTaskManagerInfo().getConfiguration(), (ClassLoader)this.getUserCodeClassLoader(), (Logger)LOG);
    }

    @VisibleForTesting
    TimerService getTimerService() {
        return this.timerService;
    }

    @VisibleForTesting
    OP getMainOperator() {
        return this.mainOperator;
    }

    @VisibleForTesting
    StreamTaskActionExecutor getActionExecutor() {
        return this.actionExecutor;
    }

    public ProcessingTimeServiceFactory getProcessingTimeServiceFactory() {
        return mailboxExecutor -> new ProcessingTimeServiceImpl(this.timerService, callback -> this.deferCallbackToMailbox(mailboxExecutor, (ProcessingTimeCallback)callback));
    }

    @Override
    public void handleAsyncException(String message, Throwable exception) {
        if (this.isRunning) {
            this.asyncExceptionHandler.handleAsyncException(message, exception);
        }
    }

    public String toString() {
        return this.getName();
    }

    public final CloseableRegistry getCancelables() {
        return this.cancelables;
    }

    @VisibleForTesting
    public static <OUT> RecordWriterDelegate<SerializationDelegate<StreamRecord<OUT>>> createRecordWriterDelegate(StreamConfig configuration, Environment environment) {
        List<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>> recordWrites = StreamTask.createRecordWriters(configuration, environment);
        if (recordWrites.size() == 1) {
            return new SingleRecordWriter(recordWrites.get(0));
        }
        if (recordWrites.size() == 0) {
            return new NonRecordWriter();
        }
        return new MultipleRecordWriters(recordWrites);
    }

    private static <OUT> List<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>> createRecordWriters(StreamConfig configuration, Environment environment) {
        ArrayList<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>> recordWriters = new ArrayList<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>>();
        List<StreamEdge> outEdgesInOrder = configuration.getOutEdgesInOrder(environment.getUserCodeClassLoader().asClassLoader());
        for (int i = 0; i < outEdgesInOrder.size(); ++i) {
            StreamEdge edge = outEdgesInOrder.get(i);
            recordWriters.add(StreamTask.createRecordWriter(edge, i, environment, environment.getTaskInfo().getTaskName(), edge.getBufferTimeout()));
        }
        return recordWriters;
    }

    private static <OUT> RecordWriter<SerializationDelegate<StreamRecord<OUT>>> createRecordWriter(StreamEdge edge, int outputIndex, Environment environment, String taskName, long bufferTimeout) {
        int numKeyGroups;
        StreamPartitioner outputPartitioner = null;
        try {
            outputPartitioner = (StreamPartitioner)InstantiationUtil.clone(edge.getPartitioner(), (ClassLoader)environment.getUserCodeClassLoader().asClassLoader());
        }
        catch (Exception e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
        LOG.debug("Using partitioner {} for output {} of task {}", new Object[]{outputPartitioner, outputIndex, taskName});
        ResultPartitionWriter bufferWriter = environment.getWriter(outputIndex);
        if (outputPartitioner instanceof ConfigurableStreamPartitioner && 0 < (numKeyGroups = bufferWriter.getNumTargetKeyGroups())) {
            ((ConfigurableStreamPartitioner)((Object)outputPartitioner)).configure(numKeyGroups);
        }
        RecordWriter output = new RecordWriterBuilder().setChannelSelector((ChannelSelector)outputPartitioner).setTimeout(bufferTimeout).setTaskName(taskName).build(bufferWriter);
        output.setMetricGroup(environment.getMetricGroup().getIOMetricGroup());
        return output;
    }

    private void handleTimerException(Exception ex) {
        this.handleAsyncException("Caught exception while processing timer.", new TimerException(ex));
    }

    @VisibleForTesting
    ProcessingTimeCallback deferCallbackToMailbox(MailboxExecutor mailboxExecutor, ProcessingTimeCallback callback) {
        return timestamp -> mailboxExecutor.execute((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> this.invokeProcessingTimeCallback(callback, timestamp)), "Timer callback for %s @ %d", callback, timestamp);
    }

    private void invokeProcessingTimeCallback(ProcessingTimeCallback callback, long timestamp) {
        try {
            callback.onProcessingTime(timestamp);
        }
        catch (Throwable t) {
            this.handleAsyncException("Caught exception while processing timer.", new TimerException(t));
        }
    }

    protected long getAsyncCheckpointStartDelayNanos() {
        return this.latestAsyncCheckpointStartDelayNanos;
    }

    private /* synthetic */ void lambda$null$1(InputGate inputGate) {
        this.mainMailboxExecutor.execute((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> ((InputGate)inputGate).requestPartitions()), "Input gate request partitions");
    }

    static class StreamTaskAsyncExceptionHandler {
        private final Environment environment;

        StreamTaskAsyncExceptionHandler(Environment environment) {
            this.environment = environment;
        }

        void handleAsyncException(String message, Throwable exception) {
            this.environment.failExternally((Throwable)new AsynchronousException(message, exception));
        }
    }
}

