/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class CheckpointConfig
implements Serializable {
    private static final long serialVersionUID = -750378776078908147L;
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointConfig.class);
    public static final CheckpointingMode DEFAULT_MODE = CheckpointingMode.EXACTLY_ONCE;
    public static final long DEFAULT_TIMEOUT = 600000L;
    public static final long DEFAULT_MIN_PAUSE_BETWEEN_CHECKPOINTS = 0L;
    public static final int DEFAULT_MAX_CONCURRENT_CHECKPOINTS = 1;
    public static final int UNDEFINED_TOLERABLE_CHECKPOINT_NUMBER = -1;
    private CheckpointingMode checkpointingMode = DEFAULT_MODE;
    private long checkpointInterval = -1L;
    private long checkpointTimeout = 600000L;
    private long minPauseBetweenCheckpoints = 0L;
    private int maxConcurrentCheckpoints = 1;
    private boolean forceCheckpointing;
    private ExternalizedCheckpointCleanup externalizedCheckpointCleanup;
    @Deprecated
    private boolean failOnCheckpointingErrors = true;
    private boolean preferCheckpointForRecovery = false;
    private int tolerableCheckpointFailureNumber = -1;

    public boolean isCheckpointingEnabled() {
        return this.checkpointInterval > 0L;
    }

    public CheckpointingMode getCheckpointingMode() {
        return this.checkpointingMode;
    }

    public void setCheckpointingMode(CheckpointingMode checkpointingMode) {
        this.checkpointingMode = Objects.requireNonNull(checkpointingMode);
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public void setCheckpointInterval(long checkpointInterval) {
        if (checkpointInterval < 10L) {
            throw new IllegalArgumentException(String.format("Checkpoint interval must be larger than or equal to %s ms", 10L));
        }
        this.checkpointInterval = checkpointInterval;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    public void setCheckpointTimeout(long checkpointTimeout) {
        if (checkpointTimeout < 10L) {
            throw new IllegalArgumentException(String.format("Checkpoint timeout must be larger than or equal to %s ms", 10L));
        }
        this.checkpointTimeout = checkpointTimeout;
    }

    public long getMinPauseBetweenCheckpoints() {
        return this.minPauseBetweenCheckpoints;
    }

    public void setMinPauseBetweenCheckpoints(long minPauseBetweenCheckpoints) {
        if (minPauseBetweenCheckpoints < 0L) {
            throw new IllegalArgumentException("Pause value must be zero or positive");
        }
        this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
    }

    public int getMaxConcurrentCheckpoints() {
        return this.maxConcurrentCheckpoints;
    }

    public void setMaxConcurrentCheckpoints(int maxConcurrentCheckpoints) {
        if (maxConcurrentCheckpoints < 1) {
            throw new IllegalArgumentException("The maximum number of concurrent attempts must be at least one.");
        }
        this.maxConcurrentCheckpoints = maxConcurrentCheckpoints;
    }

    @Deprecated
    @PublicEvolving
    public boolean isForceCheckpointing() {
        return this.forceCheckpointing;
    }

    @Deprecated
    @PublicEvolving
    public void setForceCheckpointing(boolean forceCheckpointing) {
        this.forceCheckpointing = forceCheckpointing;
    }

    @Deprecated
    public boolean isFailOnCheckpointingErrors() {
        return this.failOnCheckpointingErrors;
    }

    @Deprecated
    public void setFailOnCheckpointingErrors(boolean failOnCheckpointingErrors) {
        if (this.tolerableCheckpointFailureNumber != -1) {
            LOG.warn("Since tolerableCheckpointFailureNumber has been configured as {}, deprecated #setFailOnCheckpointingErrors(boolean) method would not take any effect and please use #setTolerableCheckpointFailureNumber(int) method to determine your expected behaviour when checkpoint errors on task side.", (Object)this.tolerableCheckpointFailureNumber);
            return;
        }
        this.failOnCheckpointingErrors = failOnCheckpointingErrors;
        this.tolerableCheckpointFailureNumber = failOnCheckpointingErrors ? 0 : Integer.MAX_VALUE;
    }

    public int getTolerableCheckpointFailureNumber() {
        if (this.tolerableCheckpointFailureNumber == -1) {
            return 0;
        }
        return this.tolerableCheckpointFailureNumber;
    }

    public void setTolerableCheckpointFailureNumber(int tolerableCheckpointFailureNumber) {
        if (tolerableCheckpointFailureNumber < 0) {
            throw new IllegalArgumentException("The tolerable failure checkpoint number must be non-negative.");
        }
        this.tolerableCheckpointFailureNumber = tolerableCheckpointFailureNumber;
    }

    @PublicEvolving
    public void enableExternalizedCheckpoints(ExternalizedCheckpointCleanup cleanupMode) {
        this.externalizedCheckpointCleanup = (ExternalizedCheckpointCleanup)((Object)Preconditions.checkNotNull((Object)((Object)cleanupMode)));
    }

    @PublicEvolving
    public boolean isExternalizedCheckpointsEnabled() {
        return this.externalizedCheckpointCleanup != null;
    }

    @PublicEvolving
    public boolean isPreferCheckpointForRecovery() {
        return this.preferCheckpointForRecovery;
    }

    @PublicEvolving
    public void setPreferCheckpointForRecovery(boolean preferCheckpointForRecovery) {
        this.preferCheckpointForRecovery = preferCheckpointForRecovery;
    }

    @PublicEvolving
    public ExternalizedCheckpointCleanup getExternalizedCheckpointCleanup() {
        return this.externalizedCheckpointCleanup;
    }

    public void configure(ReadableConfig configuration) {
        configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINTING_MODE).ifPresent(this::setCheckpointingMode);
        configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINTING_INTERVAL).ifPresent(i -> this.setCheckpointInterval(i.toMillis()));
        configuration.getOptional(ExecutionCheckpointingOptions.CHECKPOINTING_TIMEOUT).ifPresent(t -> this.setCheckpointTimeout(t.toMillis()));
        configuration.getOptional(ExecutionCheckpointingOptions.MAX_CONCURRENT_CHECKPOINTS).ifPresent(this::setMaxConcurrentCheckpoints);
        configuration.getOptional(ExecutionCheckpointingOptions.MIN_PAUSE_BETWEEN_CHECKPOINTS).ifPresent(m -> this.setMinPauseBetweenCheckpoints(m.toMillis()));
        configuration.getOptional(ExecutionCheckpointingOptions.PREFER_CHECKPOINT_FOR_RECOVERY).ifPresent(this::setPreferCheckpointForRecovery);
        configuration.getOptional(ExecutionCheckpointingOptions.TOLERABLE_FAILURE_NUMBER).ifPresent(this::setTolerableCheckpointFailureNumber);
        configuration.getOptional(ExecutionCheckpointingOptions.EXTERNALIZED_CHECKPOINT).ifPresent(this::enableExternalizedCheckpoints);
    }

    @PublicEvolving
    public static enum ExternalizedCheckpointCleanup {
        DELETE_ON_CANCELLATION(true),
        RETAIN_ON_CANCELLATION(false);

        private final boolean deleteOnCancellation;

        private ExternalizedCheckpointCleanup(boolean deleteOnCancellation) {
            this.deleteOnCancellation = deleteOnCancellation;
        }

        public boolean deleteOnCancellation() {
            return this.deleteOnCancellation;
        }
    }
}

