/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.client.program.OptimizerPlanEnvironment;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;

@PublicEvolving
public class StreamPlanEnvironment
extends StreamExecutionEnvironment {
    private ExecutionEnvironment env;

    protected StreamPlanEnvironment(ExecutionEnvironment env) {
        super(env.getConfiguration());
        this.env = env;
        int parallelism = env.getParallelism();
        if (parallelism > 0) {
            this.setParallelism(parallelism);
        } else {
            this.setParallelism(GlobalConfiguration.loadConfiguration().getInteger(CoreOptions.DEFAULT_PARALLELISM));
        }
    }

    @Override
    public JobClient executeAsync(StreamGraph streamGraph) throws Exception {
        if (this.env instanceof OptimizerPlanEnvironment) {
            ((OptimizerPlanEnvironment)this.env).setPipeline((Pipeline)streamGraph);
        }
        throw new OptimizerPlanEnvironment.ProgramAbortException();
    }
}

