/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;

@Internal
public class SelectTransformation<T>
extends Transformation<T> {
    private final Transformation<T> input;
    private final List<String> selectedNames;

    public SelectTransformation(Transformation<T> input, List<String> selectedNames) {
        super("Select", input.getOutputType(), input.getParallelism());
        this.input = input;
        this.selectedNames = selectedNames;
    }

    public Transformation<T> getInput() {
        return this.input;
    }

    public List<String> getSelectedNames() {
        return this.selectedNames;
    }

    public Collection<Transformation<?>> getTransitivePredecessors() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }
}

