/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.io.StreamInputProcessor;
import org.apache.flink.streaming.runtime.io.StreamTaskInput;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class StreamOneInputProcessor<IN>
implements StreamInputProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(StreamOneInputProcessor.class);
    private final StreamTaskInput<IN> input;
    private final PushingAsyncDataInput.DataOutput<IN> output;
    private final BoundedMultiInput endOfInputAware;

    public StreamOneInputProcessor(StreamTaskInput<IN> input, PushingAsyncDataInput.DataOutput<IN> output, BoundedMultiInput endOfInputAware) {
        this.input = (StreamTaskInput)Preconditions.checkNotNull(input);
        this.output = (PushingAsyncDataInput.DataOutput)Preconditions.checkNotNull(output);
        this.endOfInputAware = (BoundedMultiInput)Preconditions.checkNotNull((Object)endOfInputAware);
    }

    public CompletableFuture<?> getAvailableFuture() {
        return this.input.getAvailableFuture();
    }

    @Override
    public InputStatus processInput() throws Exception {
        InputStatus status = this.input.emitNext(this.output);
        if (status == InputStatus.END_OF_INPUT) {
            this.endOfInputAware.endInput(this.input.getInputIndex() + 1);
        }
        return status;
    }

    @Override
    public CompletableFuture<Void> prepareSnapshot(ChannelStateWriter channelStateWriter, long checkpointId) throws IOException {
        return this.input.prepareSnapshot(channelStateWriter, checkpointId);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

