/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.table.api.PlannerType;
import org.apache.flink.table.api.config.TableConfigOptions;

@PublicEvolving
public class EnvironmentSettings {
    public static final String STREAMING_MODE = "streaming-mode";
    public static final String CLASS_NAME = "class-name";
    public static final String DEFAULT_BUILTIN_CATALOG = "default_catalog";
    public static final String DEFAULT_BUILTIN_DATABASE = "default_database";
    private final String plannerClass;
    private final String executorClass;
    private final String builtInCatalogName;
    private final String builtInDatabaseName;
    private final boolean isStreamingMode;

    private EnvironmentSettings(@Nullable String plannerClass, @Nullable String executorClass, String builtInCatalogName, String builtInDatabaseName, boolean isStreamingMode) {
        this.plannerClass = plannerClass;
        this.executorClass = executorClass;
        this.builtInCatalogName = builtInCatalogName;
        this.builtInDatabaseName = builtInDatabaseName;
        this.isStreamingMode = isStreamingMode;
    }

    public static Builder newInstance() {
        return new Builder();
    }

    public static EnvironmentSettings fromConfiguration(Configuration configuration) {
        Builder builder = new Builder();
        if (((RuntimeExecutionMode)configuration.get(ExecutionOptions.RUNTIME_MODE)).equals((Object)RuntimeExecutionMode.STREAMING)) {
            builder.inStreamingMode();
        } else {
            builder.inBatchMode();
        }
        switch ((RuntimeExecutionMode)configuration.get(ExecutionOptions.RUNTIME_MODE)) {
            case STREAMING: {
                builder.inStreamingMode();
                break;
            }
            case BATCH: {
                builder.inBatchMode();
                break;
            }
            case AUTOMATIC: {
                throw new UnsupportedOperationException("TableEnvironment currently doesn't support `AUTOMATIC` mode.");
            }
            default: {
                throw new IllegalArgumentException(String.format("Unrecognized value '%s' for option '%s'.", configuration.get(ExecutionOptions.RUNTIME_MODE), ExecutionOptions.RUNTIME_MODE.key()));
            }
        }
        switch ((PlannerType)((Object)configuration.get(TableConfigOptions.TABLE_PLANNER))) {
            case BLINK: {
                builder.useBlinkPlanner();
                break;
            }
            case OLD: {
                builder.useOldPlanner();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unrecognized value '%s' for option '%s'.", configuration.get(TableConfigOptions.TABLE_PLANNER), TableConfigOptions.TABLE_PLANNER.key()));
            }
        }
        return builder.build();
    }

    public Configuration toConfiguration() {
        Configuration configuration = new Configuration();
        configuration.set(ExecutionOptions.RUNTIME_MODE, (Object)(this.isStreamingMode() ? RuntimeExecutionMode.STREAMING : RuntimeExecutionMode.BATCH));
        configuration.set(TableConfigOptions.TABLE_PLANNER, (Object)(this.isBlinkPlanner() ? PlannerType.BLINK : PlannerType.OLD));
        return configuration;
    }

    public String getBuiltInCatalogName() {
        return this.builtInCatalogName;
    }

    public String getBuiltInDatabaseName() {
        return this.builtInDatabaseName;
    }

    public boolean isStreamingMode() {
        return this.isStreamingMode;
    }

    public boolean isBlinkPlanner() {
        return this.plannerClass == null && this.executorClass == null || "org.apache.flink.table.planner.delegation.BlinkPlannerFactory".equals(this.plannerClass) && "org.apache.flink.table.planner.delegation.BlinkExecutorFactory".equals(this.executorClass);
    }

    @Internal
    public Map<String, String> toPlannerProperties() {
        HashMap<String, String> properties = new HashMap<String, String>(this.toCommonProperties());
        if (this.plannerClass != null) {
            properties.put(CLASS_NAME, this.plannerClass);
        }
        return properties;
    }

    @Internal
    public Map<String, String> toExecutorProperties() {
        HashMap<String, String> properties = new HashMap<String, String>(this.toCommonProperties());
        if (this.executorClass != null) {
            properties.put(CLASS_NAME, this.executorClass);
        }
        return properties;
    }

    private Map<String, String> toCommonProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(STREAMING_MODE, Boolean.toString(this.isStreamingMode));
        return properties;
    }

    public static class Builder {
        private static final String OLD_PLANNER_FACTORY = "org.apache.flink.table.planner.StreamPlannerFactory";
        private static final String OLD_EXECUTOR_FACTORY = "org.apache.flink.table.executor.StreamExecutorFactory";
        private static final String BLINK_PLANNER_FACTORY = "org.apache.flink.table.planner.delegation.BlinkPlannerFactory";
        private static final String BLINK_EXECUTOR_FACTORY = "org.apache.flink.table.planner.delegation.BlinkExecutorFactory";
        private String plannerClass = "org.apache.flink.table.planner.delegation.BlinkPlannerFactory";
        private String executorClass = "org.apache.flink.table.planner.delegation.BlinkExecutorFactory";
        private String builtInCatalogName = "default_catalog";
        private String builtInDatabaseName = "default_database";
        private boolean isStreamingMode = true;

        @Deprecated
        public Builder useOldPlanner() {
            this.plannerClass = OLD_PLANNER_FACTORY;
            this.executorClass = OLD_EXECUTOR_FACTORY;
            return this;
        }

        public Builder useBlinkPlanner() {
            this.plannerClass = BLINK_PLANNER_FACTORY;
            this.executorClass = BLINK_EXECUTOR_FACTORY;
            return this;
        }

        public Builder useAnyPlanner() {
            this.plannerClass = null;
            this.executorClass = null;
            return this;
        }

        public Builder inBatchMode() {
            this.isStreamingMode = false;
            return this;
        }

        public Builder inStreamingMode() {
            this.isStreamingMode = true;
            return this;
        }

        public Builder withBuiltInCatalogName(String builtInCatalogName) {
            this.builtInCatalogName = builtInCatalogName;
            return this;
        }

        public Builder withBuiltInDatabaseName(String builtInDatabaseName) {
            this.builtInDatabaseName = builtInDatabaseName;
            return this;
        }

        public EnvironmentSettings build() {
            return new EnvironmentSettings(this.plannerClass, this.executorClass, this.builtInCatalogName, this.builtInDatabaseName, this.isStreamingMode);
        }
    }
}

