/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.resolver.SqlExpressionResolver;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;

@Internal
final class ResolveSqlCallRule
implements ResolverRule {
    ResolveSqlCallRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression, ResolverRule.ResolutionContext context) {
        return expression.stream().map(expr -> (Expression)expr.accept((ExpressionVisitor)new TranslateSqlCallsVisitor(context))).collect(Collectors.toList());
    }

    private static class TranslateSqlCallsVisitor
    extends RuleExpressionVisitor<Expression> {
        TranslateSqlCallsVisitor(ResolverRule.ResolutionContext resolutionContext) {
            super(resolutionContext);
        }

        @Override
        public Expression visit(SqlCallExpression sqlCall) {
            SqlExpressionResolver resolver = this.resolutionContext.sqlExpressionResolver();
            TableSchema.Builder builder = TableSchema.builder();
            this.resolutionContext.referenceLookup().getAllInputFields().forEach(f -> builder.field(f.getName(), f.getOutputDataType()));
            this.resolutionContext.getLocalReferences().forEach(refs -> builder.field(refs.getName(), refs.getOutputDataType()));
            return resolver.resolveExpression(sqlCall.getSqlExpression(), builder.build());
        }

        @Override
        public Expression visit(UnresolvedCallExpression unresolvedCall) {
            return unresolvedCall.replaceArgs(this.resolveChildren(unresolvedCall.getChildren()));
        }

        @Override
        protected Expression defaultMethod(Expression expression) {
            return expression;
        }

        private List<Expression> resolveChildren(List<Expression> lookupChildren) {
            return lookupChildren.stream().map(child -> (Expression)child.accept((ExpressionVisitor)this)).collect(Collectors.toList());
        }
    }
}

