/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.ModifyOperationVisitor;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;

@Internal
public class CatalogSinkModifyOperation
implements ModifyOperation {
    private final ObjectIdentifier tableIdentifier;
    private final Map<String, String> staticPartitions;
    private final QueryOperation child;
    private final boolean overwrite;
    private final Map<String, String> dynamicOptions;

    public CatalogSinkModifyOperation(ObjectIdentifier tableIdentifier, QueryOperation child) {
        this(tableIdentifier, child, Collections.emptyMap(), false, Collections.emptyMap());
    }

    public CatalogSinkModifyOperation(ObjectIdentifier tableIdentifier, QueryOperation child, Map<String, String> staticPartitions, boolean overwrite, Map<String, String> dynamicOptions) {
        this.tableIdentifier = tableIdentifier;
        this.child = child;
        this.staticPartitions = staticPartitions;
        this.overwrite = overwrite;
        this.dynamicOptions = dynamicOptions;
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public Map<String, String> getStaticPartitions() {
        return this.staticPartitions;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public Map<String, String> getDynamicOptions() {
        return this.dynamicOptions;
    }

    @Override
    public QueryOperation getChild() {
        return this.child;
    }

    @Override
    public <T> T accept(ModifyOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("identifier", this.tableIdentifier);
        params.put("staticPartitions", this.staticPartitions);
        params.put("overwrite", this.overwrite);
        params.put("dynamicOptions", this.dynamicOptions);
        return OperationUtils.formatWithChildren("CatalogSink", params, Collections.singletonList(this.child), Operation::asSummaryString);
    }
}

