/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.operations.QueryOperation;

@Internal
public final class QueryOperationCatalogView
implements CatalogView {
    private final QueryOperation queryOperation;

    public QueryOperationCatalogView(QueryOperation queryOperation) {
        this.queryOperation = queryOperation;
    }

    public QueryOperation getQueryOperation() {
        return this.queryOperation;
    }

    public Schema getUnresolvedSchema() {
        return Schema.newBuilder().fromResolvedSchema(this.queryOperation.getResolvedSchema()).build();
    }

    public Map<String, String> getOptions() {
        throw new TableException("A view backed by a query operation has no options.");
    }

    public String getComment() {
        return this.queryOperation.asSummaryString();
    }

    public QueryOperationCatalogView copy() {
        return new QueryOperationCatalogView(this.queryOperation);
    }

    public Optional<String> getDescription() {
        return Optional.of(this.getComment());
    }

    public Optional<String> getDetailedDescription() {
        return this.getDescription();
    }

    public String getOriginalQuery() {
        throw new TableException("A view backed by a query operation has no serializable representation.");
    }

    public String getExpandedQuery() {
        throw new TableException("A view backed by a query operation has no serializable representation.");
    }
}

