/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionArgumentTemplate;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;

@Internal
final class FunctionSignatureTemplate {
    final List<FunctionArgumentTemplate> argumentTemplates;
    final boolean isVarArgs;
    @Nullable
    final String[] argumentNames;

    private FunctionSignatureTemplate(List<FunctionArgumentTemplate> argumentTemplates, boolean isVarArgs, @Nullable String[] argumentNames) {
        this.argumentTemplates = argumentTemplates;
        this.isVarArgs = isVarArgs;
        this.argumentNames = argumentNames;
    }

    static FunctionSignatureTemplate of(List<FunctionArgumentTemplate> argumentTemplates, boolean isVarArgs, @Nullable String[] argumentNames) {
        if (argumentNames != null && argumentNames.length != argumentTemplates.size()) {
            throw ExtractionUtils.extractionError("Mismatch between number of argument names '%s' and argument types '%s'.", argumentNames.length, argumentTemplates.size());
        }
        return new FunctionSignatureTemplate(argumentTemplates, isVarArgs, argumentNames);
    }

    InputTypeStrategy toInputTypeStrategy() {
        ArgumentTypeStrategy[] argumentStrategies = (ArgumentTypeStrategy[])this.argumentTemplates.stream().map(FunctionArgumentTemplate::toArgumentTypeStrategy).toArray(ArgumentTypeStrategy[]::new);
        InputTypeStrategy strategy = this.isVarArgs ? (this.argumentNames == null ? InputTypeStrategies.varyingSequence(argumentStrategies) : InputTypeStrategies.varyingSequence(this.argumentNames, argumentStrategies)) : (this.argumentNames == null ? InputTypeStrategies.sequence(argumentStrategies) : InputTypeStrategies.sequence(this.argumentNames, argumentStrategies));
        return strategy;
    }

    List<Class<?>> toClass() {
        return IntStream.range(0, this.argumentTemplates.size()).mapToObj(i -> {
            Class<?> clazz = this.argumentTemplates.get(i).toConversionClass();
            if (i == this.argumentTemplates.size() - 1 && this.isVarArgs) {
                return Array.newInstance(clazz, 0).getClass();
            }
            return clazz;
        }).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionSignatureTemplate that = (FunctionSignatureTemplate)o;
        return this.isVarArgs == that.isVarArgs && this.argumentTemplates.equals(that.argumentTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.argumentTemplates, this.isVarArgs);
    }
}

