/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class AggregateExpression
implements ResolvedExpression {
    private final FunctionDefinition functionDefinition;
    private final List<FieldReferenceExpression> args;
    @Nullable
    private final CallExpression filterExpression;
    private final DataType resultType;
    private final boolean distinct;
    private final boolean approximate;
    private final boolean ignoreNulls;

    public AggregateExpression(FunctionDefinition functionDefinition, List<FieldReferenceExpression> args, @Nullable CallExpression filterExpression, DataType resultType, boolean distinct, boolean approximate, boolean ignoreNulls) {
        this.functionDefinition = (FunctionDefinition)Preconditions.checkNotNull((Object)functionDefinition, (String)"Function definition must not be null.");
        this.args = args;
        this.filterExpression = filterExpression;
        this.resultType = resultType;
        this.distinct = distinct;
        this.approximate = approximate;
        this.ignoreNulls = ignoreNulls;
    }

    public FunctionDefinition getFunctionDefinition() {
        return this.functionDefinition;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean isApproximate() {
        return this.approximate;
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    public List<FieldReferenceExpression> getArgs() {
        return this.args;
    }

    @Nullable
    public Optional<CallExpression> getFilterExpression() {
        return Optional.ofNullable(this.filterExpression);
    }

    @Override
    public DataType getOutputDataType() {
        return this.resultType;
    }

    @Override
    public List<ResolvedExpression> getResolvedChildren() {
        ArrayList<FieldReferenceExpression> resolvedChildren = new ArrayList<FieldReferenceExpression>(this.args);
        resolvedChildren.add((FieldReferenceExpression)((Object)this.filterExpression));
        return Collections.unmodifiableList(resolvedChildren);
    }

    @Override
    public String asSummaryString() {
        String argList = this.args.stream().map(Expression::asSummaryString).collect(Collectors.joining(", ", "(", ")"));
        return this.functionDefinition.toString() + argList;
    }

    @Override
    public List<Expression> getChildren() {
        ArrayList<FieldReferenceExpression> children = new ArrayList<FieldReferenceExpression>(this.args);
        children.add((FieldReferenceExpression)((Object)this.filterExpression));
        return Collections.unmodifiableList(children);
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateExpression that = (AggregateExpression)o;
        return Objects.equals(this.functionDefinition, that.functionDefinition) && Objects.equals(this.args, that.args) && Objects.equals(this.filterExpression, that.filterExpression) && Objects.equals(this.resultType, that.resultType) && Objects.equals(this.distinct, that.distinct) && Objects.equals(this.approximate, that.approximate) && Objects.equals(this.ignoreNulls, that.ignoreNulls);
    }

    public int hashCode() {
        return Objects.hash(this.functionDefinition, this.args, this.filterExpression, this.resultType, this.distinct, this.approximate, this.ignoreNulls);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

