/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public final class CommonArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private static final Signature.Argument COMMON_ARGUMENT = Signature.Argument.of("<COMMON>");
    private final boolean preserveNullability;

    public CommonArgumentTypeStrategy(boolean preserveNullability) {
        this.preserveNullability = preserveNullability;
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        List<LogicalType> actualTypes = callContext.getArgumentDataTypes().stream().map(DataType::getLogicalType).collect(Collectors.toList());
        return LogicalTypeMerging.findCommonType(actualTypes).map(commonType -> this.preserveNullability ? commonType.copy(((LogicalType)actualTypes.get(argumentPos)).isNullable()) : commonType).map(TypeConversions::fromLogicalToDataType);
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return COMMON_ARGUMENT;
    }
}

