/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.ftpserver.util;

/**
 * <strong>Internal class, do not use directly.</strong>
 *
 * @author <a href="http://mina.apache.org">Apache MINA Project</a> *
 */
public class ClassUtils {

    /**
     * Checks if a class is a subclass of a class with the specified name. Used
     * as an instanceOf without having to load the class, useful when trying to
     * check for classes that might not be available in the runtime JRE.
     * 
     * @param clazz
     *            The class to check
     * @param className
     *            The class name to look for in the super classes
     * @return true if the class extends a class by the specified name.
     */
    public static boolean extendsClass(final Class<?> clazz, String className) {
        Class<?> superClass = clazz.getSuperclass();

        while (superClass != null) {
            if (superClass.getName().equals(className)) {
                return true;
            }
            superClass = superClass.getSuperclass();

        }
        return false;
    }
}
