/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.nio;

import java.net.InetAddress;
import java.util.List;
import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.ipfilter.DefaultIpFilter;
import org.apache.ftpserver.ipfilter.IpFilter;
import org.apache.ftpserver.ipfilter.IpFilterType;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.mina.filter.firewall.Subnet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListener
implements Listener {
    private String serverAddress;
    private int port = 21;
    private SslConfiguration ssl;
    private boolean implicitSsl = false;
    private int idleTimeout;
    private List<InetAddress> blockedAddresses;
    private List<Subnet> blockedSubnets;
    private IpFilter ipFilter = null;
    private DataConnectionConfiguration dataConnectionConfig;

    @Deprecated
    public AbstractListener(String serverAddress, int port, boolean implicitSsl, SslConfiguration sslConfiguration, DataConnectionConfiguration dataConnectionConfig, int idleTimeout, List<InetAddress> blockedAddresses, List<Subnet> blockedSubnets) {
        this(serverAddress, port, implicitSsl, sslConfiguration, dataConnectionConfig, idleTimeout, AbstractListener.createBlackListFilter(blockedAddresses, blockedSubnets));
        this.blockedAddresses = blockedAddresses;
        this.blockedSubnets = blockedSubnets;
    }

    public AbstractListener(String serverAddress, int port, boolean implicitSsl, SslConfiguration sslConfiguration, DataConnectionConfiguration dataConnectionConfig, int idleTimeout, IpFilter ipFilter) {
        this.serverAddress = serverAddress;
        this.port = port;
        this.implicitSsl = implicitSsl;
        this.dataConnectionConfig = dataConnectionConfig;
        this.ssl = sslConfiguration;
        this.idleTimeout = idleTimeout;
        this.ipFilter = ipFilter;
    }

    private static IpFilter createBlackListFilter(List<InetAddress> blockedAddresses, List<Subnet> blockedSubnets) {
        if (blockedAddresses == null && blockedSubnets == null) {
            return null;
        }
        DefaultIpFilter ipFilter = new DefaultIpFilter(IpFilterType.DENY);
        if (blockedSubnets != null) {
            ipFilter.addAll(blockedSubnets);
        }
        if (blockedAddresses != null) {
            for (InetAddress address : blockedAddresses) {
                ipFilter.add(new Subnet(address, 32));
            }
        }
        return ipFilter;
    }

    @Override
    public boolean isImplicitSsl() {
        return this.implicitSsl;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    protected void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public SslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    @Override
    public DataConnectionConfiguration getDataConnectionConfiguration() {
        return this.dataConnectionConfig;
    }

    @Override
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public List<InetAddress> getBlockedAddresses() {
        return this.blockedAddresses;
    }

    @Override
    public List<Subnet> getBlockedSubnets() {
        return this.blockedSubnets;
    }

    @Override
    public IpFilter getIpFilter() {
        return this.ipFilter;
    }
}

