/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import java.util.List;
import org.apache.hadoop.fs.s3a.AWSClientIOException;
import org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.hadoop.fs.s3a.S3AStorageStatistics;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkDeleteRetryHandler
extends AbstractStoreOperation {
    private static final Logger LOG = LoggerFactory.getLogger(BulkDeleteRetryHandler.class);
    private static final Logger THROTTLE_LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.fs.s3a.throttled");
    public static final String XML_PARSE_BROKEN = "Failed to parse XML document";
    private final S3AInstrumentation instrumentation;
    private final S3AStorageStatistics storageStatistics;

    public BulkDeleteRetryHandler(StoreContext storeContext) {
        super(storeContext);
        this.instrumentation = storeContext.getInstrumentation();
        this.storageStatistics = storeContext.getStorageStatistics();
    }

    protected void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1L);
    }

    protected void incrementStatistic(Statistic statistic, long count) {
        this.instrumentation.incrementCounter(statistic, count);
        this.storageStatistics.incrementCounter(statistic, count);
    }

    public void bulkDeleteRetried(DeleteObjectsRequest deleteRequest, Exception ex) {
        LOG.debug("Retrying on error during bulk delete", (Throwable)ex);
        if (S3AUtils.isThrottleException(ex)) {
            this.onDeleteThrottled(deleteRequest);
        } else if (this.isSymptomOfBrokenConnection(ex)) {
            LOG.warn("Bulk delete operation interrupted: {}", (Object)ex.getMessage());
            this.onDeleteThrottled(deleteRequest);
        } else {
            this.incrementStatistic(Statistic.IGNORED_ERRORS);
        }
    }

    private void onDeleteThrottled(DeleteObjectsRequest deleteRequest) {
        List keys = deleteRequest.getKeys();
        int size = keys.size();
        this.incrementStatistic(Statistic.STORE_IO_THROTTLED, size);
        this.instrumentation.addValueToQuantiles(Statistic.STORE_IO_THROTTLE_RATE, size);
        THROTTLE_LOG.info("Bulk delete {} keys throttled -first key = {}; last = {}", new Object[]{size, ((DeleteObjectsRequest.KeyVersion)keys.get(0)).getKey(), ((DeleteObjectsRequest.KeyVersion)keys.get(size - 1)).getKey()});
    }

    private boolean isSymptomOfBrokenConnection(Exception ex) {
        return ex instanceof AWSClientIOException && ex.getCause() instanceof SdkClientException && ex.getMessage().contains(XML_PARSE_BROKEN);
    }
}

