/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.AWSS3IOException;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiObjectDeleteSupport
extends AbstractStoreOperation {
    private static final Logger LOG = LoggerFactory.getLogger(MultiObjectDeleteSupport.class);
    private final BulkOperationState operationState;
    public static final String ACCESS_DENIED = "AccessDenied";

    public MultiObjectDeleteSupport(StoreContext context, BulkOperationState operationState) {
        super(context);
        this.operationState = operationState;
    }

    public static IOException translateDeleteException(String message, MultiObjectDeleteException deleteException) {
        StringBuilder result = new StringBuilder(deleteException.getErrors().size() * 256);
        result.append(message).append(": ");
        String exitCode = "";
        for (MultiObjectDeleteException.DeleteError error : deleteException.getErrors()) {
            String code = error.getCode();
            result.append(String.format("%s: %s: %s%n", code, error.getKey(), error.getMessage()));
            if (!exitCode.isEmpty() && !ACCESS_DENIED.equals(code)) continue;
            exitCode = code;
        }
        if (ACCESS_DENIED.equals(exitCode)) {
            return (IOException)new AccessDeniedException(result.toString()).initCause(deleteException);
        }
        return new AWSS3IOException(result.toString(), (AmazonS3Exception)((Object)deleteException));
    }

    public Pair<List<Path>, List<Path>> splitUndeletedKeys(MultiObjectDeleteException deleteException, Collection<DeleteObjectsRequest.KeyVersion> keysToDelete) {
        LOG.debug("Processing delete failure; keys to delete count = {}; errors in exception {}; successful deletions = {}", new Object[]{keysToDelete.size(), deleteException.getErrors().size(), deleteException.getDeletedObjects().size()});
        List<Path> pathsBeingDeleted = this.keysToPaths(keysToDelete);
        List<Path> undeleted = MultiObjectDeleteSupport.removeUndeletedPaths(deleteException, pathsBeingDeleted, this.getStoreContext()::keyToPath);
        return Pair.of(undeleted, pathsBeingDeleted);
    }

    public List<Path> keysToPaths(Collection<DeleteObjectsRequest.KeyVersion> keysToDelete) {
        return MultiObjectDeleteSupport.convertToPaths(keysToDelete, this.getStoreContext()::keyToPath);
    }

    public static List<Path> convertToPaths(Collection<DeleteObjectsRequest.KeyVersion> keysToDelete, Function<String, Path> qualifier) {
        return keysToDelete.stream().map(keyVersion -> (Path)qualifier.apply(keyVersion.getKey())).collect(Collectors.toList());
    }

    public Triple<List<Path>, List<Path>, List<Pair<Path, IOException>>> processDeleteFailure(MultiObjectDeleteException deleteException, List<DeleteObjectsRequest.KeyVersion> keysToDelete) {
        MetadataStore metadataStore = (MetadataStore)Preconditions.checkNotNull((Object)this.getStoreContext().getMetadataStore(), (Object)"context metadatastore");
        ArrayList failures = new ArrayList();
        Pair<List<Path>, List<Path>> outcome = this.splitUndeletedKeys(deleteException, keysToDelete);
        List deleted = (List)outcome.getRight();
        List undeleted = (List)outcome.getLeft();
        deleted.forEach(path -> {
            try {
                metadataStore.delete((Path)path, this.operationState);
            }
            catch (IOException e) {
                LOG.warn("Failed to update S3Guard store with deletion of {}", path);
                failures.add(Pair.of((Object)path, (Object)e));
            }
        });
        if (LOG.isDebugEnabled()) {
            undeleted.forEach(p -> LOG.debug("Deleted {}", p));
        }
        return Triple.of((Object)undeleted, (Object)deleted, failures);
    }

    @VisibleForTesting
    public static List<Path> extractUndeletedPaths(MultiObjectDeleteException deleteException, Function<String, Path> qualifierFn) {
        return deleteException.getErrors().stream().map(e -> (Path)qualifierFn.apply(e.getKey())).collect(Collectors.toList());
    }

    @VisibleForTesting
    static List<Path> removeUndeletedPaths(MultiObjectDeleteException deleteException, Collection<Path> pathsBeingDeleted, Function<String, Path> qualifier) {
        List<Path> undeleted = MultiObjectDeleteSupport.extractUndeletedPaths(deleteException, qualifier);
        pathsBeingDeleted.removeAll(undeleted);
        return undeleted;
    }

    public List<Path> processDeleteFailureGenericException(Exception ex, List<DeleteObjectsRequest.KeyVersion> keysToDelete) {
        return this.keysToPaths(keysToDelete);
    }
}

