/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DelegateToFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.junit.Test;

public class TestDelegateToFsCheckPath {
    @Test
    public void testCheckPathWithoutDefaultPorts() throws URISyntaxException, IOException {
        URI uri = new URI("dummy://dummy-host");
        DummyDelegateToFileSystem afs = new DummyDelegateToFileSystem(uri);
        afs.checkPath(new Path("dummy://dummy-host"));
    }

    private static class UnOverrideDefaultPortFileSystem
    extends FileSystem {
        private UnOverrideDefaultPortFileSystem() {
        }

        public URI getUri() {
            return null;
        }

        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            return null;
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return null;
        }

        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            return null;
        }

        public boolean rename(Path src, Path dst) throws IOException {
            return false;
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            return false;
        }

        public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
            return new FileStatus[0];
        }

        public void setWorkingDirectory(Path newDir) {
        }

        public Path getWorkingDirectory() {
            return null;
        }

        public boolean mkdirs(Path f, FsPermission permission) throws IOException {
            return false;
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            return null;
        }
    }

    private static class DummyDelegateToFileSystem
    extends DelegateToFileSystem {
        public DummyDelegateToFileSystem(URI uri) throws URISyntaxException, IOException {
            super(uri, (FileSystem)new UnOverrideDefaultPortFileSystem(), new Configuration(), "dummy", false);
        }
    }
}

