/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.KMSClientProvider;
import org.apache.hadoop.crypto.key.kms.LoadBalancingKMSClientProvider;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestLoadBalancingKMSClientProvider {
    @BeforeClass
    public static void setup() throws IOException {
        SecurityUtil.setTokenServiceUseIp((boolean)false);
    }

    @After
    public void teardown() throws IOException {
        KMSClientProvider.fallbackDefaultPortForTesting = false;
    }

    @Test
    public void testCreation() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider.fallbackDefaultPortForTesting = true;
        KeyProvider kp = new KMSClientProvider.Factory().createProvider(new URI("kms://http@host1/kms/foo"), conf);
        Assert.assertTrue((boolean)(kp instanceof LoadBalancingKMSClientProvider));
        KMSClientProvider[] providers = ((LoadBalancingKMSClientProvider)kp).getProviders();
        Assert.assertEquals((long)1L, (long)providers.length);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"http://host1/kms/foo/v1/"}), (Object)Sets.newHashSet((Object[])new String[]{providers[0].getKMSUrl()}));
        kp = new KMSClientProvider.Factory().createProvider(new URI("kms://http@host1;host2;host3/kms/foo"), conf);
        Assert.assertTrue((boolean)(kp instanceof LoadBalancingKMSClientProvider));
        providers = ((LoadBalancingKMSClientProvider)kp).getProviders();
        Assert.assertEquals((long)3L, (long)providers.length);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"http://host1/kms/foo/v1/", "http://host2/kms/foo/v1/", "http://host3/kms/foo/v1/"}), (Object)Sets.newHashSet((Object[])new String[]{providers[0].getKMSUrl(), providers[1].getKMSUrl(), providers[2].getKMSUrl()}));
        kp = new KMSClientProvider.Factory().createProvider(new URI("kms://http@host1;host2;host3:9600/kms/foo"), conf);
        Assert.assertTrue((boolean)(kp instanceof LoadBalancingKMSClientProvider));
        providers = ((LoadBalancingKMSClientProvider)kp).getProviders();
        Assert.assertEquals((long)3L, (long)providers.length);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"http://host1:9600/kms/foo/v1/", "http://host2:9600/kms/foo/v1/", "http://host3:9600/kms/foo/v1/"}), (Object)Sets.newHashSet((Object[])new String[]{providers[0].getKMSUrl(), providers[1].getKMSUrl(), providers[2].getKMSUrl()}));
    }

    @Test
    public void testLoadBalancing() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p1", "v1", new byte[0]));
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p2", "v2", new byte[0]));
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p3", "v3", new byte[0]));
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3}, 0L, conf);
        Assert.assertEquals((Object)"p1", (Object)kp.createKey("test1", new KeyProvider.Options(conf)).getName());
        Assert.assertEquals((Object)"p2", (Object)kp.createKey("test2", new KeyProvider.Options(conf)).getName());
        Assert.assertEquals((Object)"p3", (Object)kp.createKey("test3", new KeyProvider.Options(conf)).getName());
        Assert.assertEquals((Object)"p1", (Object)kp.createKey("test4", new KeyProvider.Options(conf)).getName());
    }

    @Test
    public void testLoadBalancingWithFailure() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p1", "v1", new byte[0]));
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new NoSuchAlgorithmException("p2")});
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p3", "v3", new byte[0]));
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        KMSClientProvider p4 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p4.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p4")});
        Mockito.when((Object)p4.getKMSUrl()).thenReturn((Object)"p4");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3, p4}, 0L, conf);
        Assert.assertEquals((Object)"p1", (Object)kp.createKey("test4", new KeyProvider.Options(conf)).getName());
        try {
            kp.createKey("test1", new KeyProvider.Options(conf)).getName();
            Assert.fail((String)"Should fail since its not an IOException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NoSuchAlgorithmException));
        }
        Assert.assertEquals((Object)"p3", (Object)kp.createKey("test2", new KeyProvider.Options(conf)).getName());
        Assert.assertEquals((Object)"p1", (Object)kp.createKey("test3", new KeyProvider.Options(conf)).getName());
    }

    @Test
    public void testLoadBalancingWithAllBadNodes() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p1")});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p2")});
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p3")});
        KMSClientProvider p4 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p4.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p4")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        Mockito.when((Object)p4.getKMSUrl()).thenReturn((Object)"p4");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3, p4}, 0L, conf);
        try {
            kp.createKey("test3", new KeyProvider.Options(conf)).getName();
            Assert.fail((String)"Should fail since all providers threw an IOException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
        }
    }

    private static void throwEx(Throwable ex) {
        TestLoadBalancingKMSClientProvider.throwException(ex);
    }

    private static <E extends Throwable> void throwException(Throwable ex) throws E {
        throw ex;
    }

    @Test
    public void testClassCastException() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider.fallbackDefaultPortForTesting = true;
        MyKMSClientProvider p1 = new MyKMSClientProvider(new URI("kms://http@host1/kms/foo"), conf);
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1}, 0L, conf);
        try {
            kp.generateEncryptedKey("foo");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getCause().getClass().getName().contains("AuthenticationException"));
        }
        try {
            KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion = (KeyProviderCryptoExtension.EncryptedKeyVersion)Mockito.mock(KeyProviderCryptoExtension.EncryptedKeyVersion.class);
            kp.decryptEncryptedKey(encryptedKeyVersion);
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getCause().getClass().getName().contains("AuthenticationException"));
        }
        try {
            KeyProvider.Options options = KeyProvider.options((Configuration)conf);
            kp.createKey("foo", options);
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getCause().getClass().getName().contains("AuthenticationException"));
        }
        try {
            kp.rollNewVersion("foo");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getCause().getClass().getName().contains("AuthenticationException"));
        }
    }

    @Test
    public void testWarmUpEncryptedKeysWhenAllProvidersFail() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        String keyName = "key1";
        ((KMSClientProvider)Mockito.doThrow((Throwable)new IOException(new AuthorizationException("p1"))).when((Object)p1)).warmUpEncryptedKeys(new String[]{Mockito.anyString()});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        ((KMSClientProvider)Mockito.doThrow((Throwable)new IOException(new AuthorizationException("p2"))).when((Object)p2)).warmUpEncryptedKeys(new String[]{Mockito.anyString()});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        try {
            kp.warmUpEncryptedKeys(new String[]{keyName});
            Assert.fail((String)"Should fail since both providers threw IOException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).warmUpEncryptedKeys(new String[]{keyName});
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).warmUpEncryptedKeys(new String[]{keyName});
    }

    @Test
    public void testWarmUpEncryptedKeysWhenOneProviderSucceeds() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        String keyName = "key1";
        ((KMSClientProvider)Mockito.doThrow((Throwable)new IOException(new AuthorizationException("p1"))).when((Object)p1)).warmUpEncryptedKeys(new String[]{Mockito.anyString()});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        ((KMSClientProvider)Mockito.doNothing().when((Object)p2)).warmUpEncryptedKeys(new String[]{Mockito.anyString()});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        try {
            kp.warmUpEncryptedKeys(new String[]{keyName});
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw Exception since p2 doesn't throw Exception");
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).warmUpEncryptedKeys(new String[]{keyName});
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).warmUpEncryptedKeys(new String[]{keyName});
    }

    @Test
    public void testClientRetriesWithIOException() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 10);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.getMetadata(Mockito.anyString())).thenThrow(new Throwable[]{new IOException("p1")});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.getMetadata(Mockito.anyString())).thenThrow(new Throwable[]{new IOException("p2")});
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.getMetadata(Mockito.anyString())).thenThrow(new Throwable[]{new IOException("p3")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3}, 0L, conf);
        try {
            kp.getMetadata("test3");
            Assert.fail((String)"Should fail since all providers threw an IOException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
        }
        ((KMSClientProvider)Mockito.verify((Object)kp.getProviders()[0], (VerificationMode)Mockito.times((int)1))).getMetadata((String)Mockito.eq((Object)"test3"));
        ((KMSClientProvider)Mockito.verify((Object)kp.getProviders()[1], (VerificationMode)Mockito.times((int)1))).getMetadata((String)Mockito.eq((Object)"test3"));
        ((KMSClientProvider)Mockito.verify((Object)kp.getProviders()[2], (VerificationMode)Mockito.times((int)1))).getMetadata((String)Mockito.eq((Object)"test3"));
    }

    @Test
    public void testClientRetriesWithAccessControlException() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 3);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new AccessControlException("p1")});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p2")});
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p3")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3}, 0L, conf);
        try {
            kp.createKey("test3", new KeyProvider.Options(conf));
            Assert.fail((String)"Should fail because provider p1 threw an AccessControlException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof AccessControlException));
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.never())).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p3, (VerificationMode)Mockito.never())).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesWithRuntimeException() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 3);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new RuntimeException("p1")});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p2")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        try {
            kp.createKey("test3", new KeyProvider.Options(conf));
            Assert.fail((String)"Should fail since provider p1 threw RuntimeException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof RuntimeException));
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.never())).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesWithTimeoutsException() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 4);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p1")});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new UnknownHostException("p2")});
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new NoRouteToHostException("p3")});
        KMSClientProvider p4 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p4.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("test3", "v1", new byte[0]));
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        Mockito.when((Object)p4.getKMSUrl()).thenReturn((Object)"p4");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3, p4}, 0L, conf);
        try {
            kp.createKey("test3", new KeyProvider.Options(conf));
        }
        catch (Exception e) {
            Assert.fail((String)"Provider p4 should have answered the request.");
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p3, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p4, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesSucceedsSecondTime() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 3);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p1")}).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("test3", "v1", new byte[0]));
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p2")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        try {
            kp.createKey("test3", new KeyProvider.Options(conf));
        }
        catch (Exception e) {
            Assert.fail((String)"Provider p1 should have answered the request second time.");
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)2))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesSpecifiedNumberOfTimes() throws Exception {
        KMSClientProvider p2;
        KMSClientProvider p1;
        block2: {
            Configuration conf = new Configuration();
            conf.setInt("hadoop.security.kms.client.failover.max.retries", 10);
            p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
            Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p1")});
            p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
            Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p2")});
            Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
            Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
            LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
            try {
                kp.createKey("test3", new KeyProvider.Options(conf));
                Assert.fail((String)"Should fail");
            }
            catch (Exception e) {
                if ($assertionsDisabled || e instanceof ConnectTimeoutException) break block2;
                throw new AssertionError();
            }
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)6))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)5))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesIfMaxAttemptsNotSet() throws Exception {
        KMSClientProvider p2;
        KMSClientProvider p1;
        block2: {
            Configuration conf = new Configuration();
            p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
            Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p1")});
            p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
            Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p2")});
            Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
            Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
            LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
            try {
                kp.createKey("test3", new KeyProvider.Options(conf));
                Assert.fail((String)"Should fail");
            }
            catch (Exception e) {
                if ($assertionsDisabled || e instanceof ConnectTimeoutException) break block2;
                throw new AssertionError();
            }
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)2))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesWithAuthenticationExceptionWrappedinIOException() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 3);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException(new AuthenticationException("p1"))});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException(new AuthenticationException("p1"))});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        try {
            kp.createKey("test3", new KeyProvider.Options(conf));
            Assert.fail((String)"Should fail since provider p1 threw AuthenticationException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof AuthenticationException));
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    private class MyKMSClientProvider
    extends KMSClientProvider {
        public MyKMSClientProvider(URI uri, Configuration conf) throws IOException {
            super(uri, conf);
        }

        public KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
            TestLoadBalancingKMSClientProvider.throwEx(new AuthenticationException("bar"));
            return null;
        }

        public KeyProvider.KeyVersion decryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
            TestLoadBalancingKMSClientProvider.throwEx(new AuthenticationException("bar"));
            return null;
        }

        public KeyProvider.KeyVersion createKey(String name, KeyProvider.Options options) throws NoSuchAlgorithmException, IOException {
            TestLoadBalancingKMSClientProvider.throwEx(new AuthenticationException("bar"));
            return null;
        }

        public KeyProvider.KeyVersion rollNewVersion(String name) throws NoSuchAlgorithmException, IOException {
            TestLoadBalancingKMSClientProvider.throwEx(new AuthenticationException("bar"));
            return null;
        }
    }
}

