/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.ArrayList;
import org.apache.hadoop.security.NetgroupCache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestNetgroupCache {
    private static final String USER1 = "user1";
    private static final String USER2 = "user2";
    private static final String USER3 = "user3";
    private static final String GROUP1 = "group1";
    private static final String GROUP2 = "group2";

    @After
    public void teardown() {
        NetgroupCache.clear();
    }

    @Test
    public void testMembership() {
        ArrayList<String> users = new ArrayList<String>();
        users.add(USER1);
        users.add(USER2);
        NetgroupCache.add((String)GROUP1, users);
        users = new ArrayList();
        users.add(USER1);
        users.add(USER3);
        NetgroupCache.add((String)GROUP2, users);
        this.verifyGroupMembership(USER1, 2, GROUP1);
        this.verifyGroupMembership(USER1, 2, GROUP2);
        this.verifyGroupMembership(USER2, 1, GROUP1);
        this.verifyGroupMembership(USER3, 1, GROUP2);
    }

    @Test
    public void testUserRemoval() {
        ArrayList<String> users = new ArrayList<String>();
        users.add(USER1);
        users.add(USER2);
        NetgroupCache.add((String)GROUP1, users);
        this.verifyGroupMembership(USER1, 1, GROUP1);
        this.verifyGroupMembership(USER2, 1, GROUP1);
        users.remove(USER2);
        NetgroupCache.clear();
        NetgroupCache.add((String)GROUP1, users);
        this.verifyGroupMembership(USER1, 1, GROUP1);
        this.verifyGroupMembership(USER2, 0, null);
    }

    @Test
    public void testGroupRemoval() {
        ArrayList<String> users = new ArrayList<String>();
        users.add(USER1);
        users.add(USER2);
        NetgroupCache.add((String)GROUP1, users);
        users = new ArrayList();
        users.add(USER1);
        users.add(USER3);
        NetgroupCache.add((String)GROUP2, users);
        this.verifyGroupMembership(USER1, 2, GROUP1);
        this.verifyGroupMembership(USER1, 2, GROUP2);
        this.verifyGroupMembership(USER2, 1, GROUP1);
        this.verifyGroupMembership(USER3, 1, GROUP2);
        NetgroupCache.clear();
        users = new ArrayList();
        users.add(USER1);
        users.add(USER2);
        NetgroupCache.add((String)GROUP1, users);
        this.verifyGroupMembership(USER1, 1, GROUP1);
        this.verifyGroupMembership(USER2, 1, GROUP1);
        this.verifyGroupMembership(USER3, 0, null);
    }

    private void verifyGroupMembership(String user, int size, String group) {
        ArrayList groups = new ArrayList();
        NetgroupCache.getNetgroups((String)user, groups);
        Assert.assertEquals((long)size, (long)groups.size());
        if (size > 0) {
            boolean present = false;
            for (String groupEntry : groups) {
                if (!groupEntry.equals(group)) continue;
                present = true;
                break;
            }
            Assert.assertTrue((boolean)present);
        }
    }
}

