/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher.testservices;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.launcher.AbstractLaunchableService;
import org.apache.hadoop.service.launcher.ServiceLaunchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoArgsAllowedService
extends AbstractLaunchableService {
    private static final Logger LOG = LoggerFactory.getLogger(NoArgsAllowedService.class);
    public static final String NAME = "org.apache.hadoop.service.launcher.testservices.NoArgsAllowedService";

    public NoArgsAllowedService() {
        super("NoArgsAllowedService");
    }

    public Configuration bindArgs(Configuration config, List<String> args) throws Exception {
        Configuration configuration = super.bindArgs(config, args);
        if (!args.isEmpty()) {
            StringBuilder argsList = new StringBuilder();
            for (String arg : args) {
                argsList.append('\"').append(arg).append("\" ");
            }
            LOG.error("Got {} arguments: {}", (Object)args.size(), (Object)argsList);
            throw new ServiceLaunchException(40, "Expected 0 arguments but got %d: %s", new Object[]{args.size(), argsList});
        }
        return configuration;
    }
}

