/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ApplicationClassLoader;
import org.apache.hadoop.util.ClassLoaderCheckMain;
import org.apache.hadoop.util.ClassLoaderCheckThird;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.util.RunJar;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRunJar {
    private static final String FOOBAR_TXT = "foobar.txt";
    private static final String FOOBAZ_TXT = "foobaz.txt";
    private static final int BUFF_SIZE = 2048;
    private File TEST_ROOT_DIR;
    private static final String TEST_JAR_NAME = "test-runjar.jar";
    private static final String TEST_JAR_2_NAME = "test-runjar2.jar";
    private static final long MOCKED_NOW = 1460389972000L;
    private static final long MOCKED_NOW_PLUS_TWO_SEC = 1460389974000L;

    @Before
    public void setUp() throws Exception {
        this.TEST_ROOT_DIR = GenericTestUtils.getTestDir(this.getClass().getSimpleName());
        if (!this.TEST_ROOT_DIR.exists()) {
            this.TEST_ROOT_DIR.mkdirs();
        }
        this.makeTestJar();
    }

    @After
    public void tearDown() {
        FileUtil.fullyDelete((File)this.TEST_ROOT_DIR);
    }

    private void makeTestJar() throws IOException {
        File jarFile = new File(this.TEST_ROOT_DIR, TEST_JAR_NAME);
        JarOutputStream jstream = new JarOutputStream(new FileOutputStream(jarFile));
        ZipEntry zipEntry1 = new ZipEntry(FOOBAR_TXT);
        zipEntry1.setTime(1460389972000L);
        jstream.putNextEntry(zipEntry1);
        jstream.closeEntry();
        ZipEntry zipEntry2 = new ZipEntry(FOOBAZ_TXT);
        zipEntry2.setTime(1460389974000L);
        jstream.putNextEntry(zipEntry2);
        jstream.closeEntry();
        jstream.close();
    }

    @Test
    public void testUnJar() throws Exception {
        File unjarDir = this.getUnjarDir("unjar-all");
        RunJar.unJar((File)new File(this.TEST_ROOT_DIR, TEST_JAR_NAME), (File)unjarDir);
        Assert.assertTrue((String)"foobar unpacked", (boolean)new File(unjarDir, FOOBAR_TXT).exists());
        Assert.assertTrue((String)"foobaz unpacked", (boolean)new File(unjarDir, FOOBAZ_TXT).exists());
    }

    @Test
    public void testUnJarWithPattern() throws Exception {
        File unjarDir = this.getUnjarDir("unjar-pattern");
        RunJar.unJar((File)new File(this.TEST_ROOT_DIR, TEST_JAR_NAME), (File)unjarDir, (Pattern)Pattern.compile(".*baz.*"));
        Assert.assertFalse((String)"foobar not unpacked", (boolean)new File(unjarDir, FOOBAR_TXT).exists());
        Assert.assertTrue((String)"foobaz unpacked", (boolean)new File(unjarDir, FOOBAZ_TXT).exists());
    }

    @Test
    public void testUnJarDoesNotLooseLastModify() throws Exception {
        File unjarDir = this.getUnjarDir("unjar-lastmod");
        RunJar.unJar((File)new File(this.TEST_ROOT_DIR, TEST_JAR_NAME), (File)unjarDir);
        String failureMessage = "Last modify time was lost during unJar";
        Assert.assertEquals((String)failureMessage, (long)1460389972000L, (long)new File(unjarDir, FOOBAR_TXT).lastModified());
        Assert.assertEquals((String)failureMessage, (long)1460389974000L, (long)new File(unjarDir, FOOBAZ_TXT).lastModified());
    }

    private File getUnjarDir(String dirName) {
        File unjarDir = new File(this.TEST_ROOT_DIR, dirName);
        Assert.assertFalse((String)"unjar dir shouldn't exist at test start", (boolean)new File(unjarDir, FOOBAR_TXT).exists());
        return unjarDir;
    }

    @Test
    public void testClientClassLoader() throws Throwable {
        RunJar runJar = (RunJar)Mockito.spy((Object)new RunJar());
        Mockito.when((Object)runJar.useClientClassLoader()).thenReturn((Object)true);
        String mainCls = ClassLoaderCheckMain.class.getName();
        String thirdCls = ClassLoaderCheckThird.class.getName();
        String systemClasses = "-" + mainCls + ",-" + thirdCls + "," + ApplicationClassLoader.SYSTEM_CLASSES_DEFAULT;
        Mockito.when((Object)runJar.getSystemClasses()).thenReturn((Object)systemClasses);
        File testJar = JarFinder.makeClassLoaderTestJar(this.getClass(), this.TEST_ROOT_DIR, TEST_JAR_2_NAME, 2048, mainCls, thirdCls);
        String[] args = new String[3];
        args[0] = testJar.getAbsolutePath();
        args[1] = mainCls;
        runJar.run(args);
    }

    @Test
    public void testUnJar2() throws IOException {
        File jarFile = new File(this.TEST_ROOT_DIR, TEST_JAR_NAME);
        JarOutputStream jstream = new JarOutputStream(new FileOutputStream(jarFile));
        JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
        byte[] data = "Manifest-Version: 1.0\nCreated-By: 1.8.0_1 (Manual)".getBytes(StandardCharsets.UTF_8);
        je.setSize(data.length);
        jstream.putNextEntry(je);
        jstream.write(data);
        jstream.closeEntry();
        je = new JarEntry("../outside.path");
        data = "any data here".getBytes(StandardCharsets.UTF_8);
        je.setSize(data.length);
        jstream.putNextEntry(je);
        jstream.write(data);
        jstream.closeEntry();
        jstream.close();
        File unjarDir = this.getUnjarDir("unjar-path");
        try {
            RunJar.unJar((File)jarFile, (File)unjarDir);
            Assert.fail((String)"unJar should throw IOException.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("would create file outside of", e);
        }
    }
}

