/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
abstract class InodeTree<T> {
    static final Path SlashPath = new Path("/");
    private final INodeDir<T> root;
    private final String homedirPrefix;
    private List<MountPoint<T>> mountPoints = new ArrayList<MountPoint<T>>();

    static String[] breakIntoPathComponents(String path) {
        return path == null ? null : path.split("/");
    }

    private void createLink(String src, String target, LinkType linkType, String settings, UserGroupInformation aUgi, Configuration config) throws URISyntaxException, IOException, FileAlreadyExistsException, UnsupportedFileSystemException {
        INodeLink<T> newLink;
        String iPath;
        int i;
        Path srcPath = new Path(src);
        if (!srcPath.isAbsoluteAndSchemeAuthorityNull()) {
            throw new IOException("ViewFs: Non absolute mount name in config:" + src);
        }
        String[] srcPaths = InodeTree.breakIntoPathComponents(src);
        INodeDir curInode = this.root;
        for (i = 1; i < srcPaths.length - 1; ++i) {
            iPath = srcPaths[i];
            INode<T> nextInode = curInode.resolveInternal(iPath);
            if (nextInode == null) {
                INodeDir<T> newDir = curInode.addDir(iPath, aUgi);
                newDir.InodeDirFs = this.getTargetFileSystem(newDir);
                nextInode = newDir;
            }
            if (nextInode instanceof INodeLink) {
                throw new FileAlreadyExistsException("Path " + nextInode.fullPath + " already exists as link");
            }
            assert (nextInode instanceof INodeDir);
            curInode = (INodeDir)nextInode;
        }
        iPath = srcPaths[i];
        if (curInode.resolveInternal(iPath) != null) {
            StringBuilder strB = new StringBuilder(srcPaths[0]);
            for (int j = 1; j <= i; ++j) {
                strB.append('/').append(srcPaths[j]);
            }
            throw new FileAlreadyExistsException("Path " + strB + " already exists as dir; cannot create link here");
        }
        String fullPath = curInode.fullPath + (curInode == this.root ? "" : "/") + iPath;
        switch (linkType) {
            case SINGLE: {
                newLink = new INodeLink<T>(fullPath, aUgi, this.getTargetFileSystem(new URI(target)), new URI(target));
                break;
            }
            case MERGE: 
            case NFLY: {
                URI[] targetUris = StringUtils.stringToURI(StringUtils.getStrings(target));
                newLink = new INodeLink<T>(fullPath, aUgi, this.getTargetFileSystem(settings, targetUris), targetUris);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)linkType) + ": Infeasible linkType");
            }
        }
        curInode.addLink(iPath, newLink);
        this.mountPoints.add(new MountPoint<T>(src, newLink));
    }

    protected abstract T getTargetFileSystem(URI var1) throws UnsupportedFileSystemException, URISyntaxException, IOException;

    protected abstract T getTargetFileSystem(INodeDir<T> var1) throws URISyntaxException;

    protected abstract T getTargetFileSystem(String var1, URI[] var2) throws UnsupportedFileSystemException, URISyntaxException, IOException;

    protected InodeTree(Configuration config, String viewName) throws UnsupportedFileSystemException, URISyntaxException, FileAlreadyExistsException, IOException {
        String vName = viewName;
        if (vName == null) {
            vName = "default";
        }
        this.homedirPrefix = ConfigUtil.getHomeDirValue(config, vName);
        this.root = new INodeDir("/", UserGroupInformation.getCurrentUser());
        this.root.InodeDirFs = this.getTargetFileSystem(this.root);
        this.root.isRoot = true;
        String mtPrefix = "fs.viewfs.mounttable." + vName + ".";
        String linkPrefix = "link.";
        String linkMergePrefix = "linkMerge.";
        boolean gotMountTableEntry = false;
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        for (Map.Entry<String, String> si : config) {
            String key = si.getKey();
            if (!key.startsWith(mtPrefix)) continue;
            gotMountTableEntry = true;
            LinkType linkType = LinkType.SINGLE;
            String src = key.substring(mtPrefix.length());
            String settings = null;
            if (src.startsWith("link.")) {
                if ((src = src.substring("link.".length())).equals(SlashPath.toString())) {
                    throw new UnsupportedFileSystemException("Unexpected mount table link entry '" + key + "'. " + "linkMergeSlash" + " is not supported yet.");
                }
            } else if (src.startsWith("linkMerge.")) {
                linkType = LinkType.MERGE;
                src = src.substring("linkMerge.".length());
            } else if (src.startsWith("linkNfly")) {
                src = src.substring("linkNfly".length() + 1);
                settings = src.substring(0, src.indexOf(46));
                src = src.substring(settings.length() + 1);
                linkType = LinkType.NFLY;
            } else {
                if (src.startsWith("homedir")) continue;
                throw new IOException("ViewFs: Cannot initialize: Invalid entry in Mount table in config: " + src);
            }
            String target = si.getValue();
            this.createLink(src, target, linkType, settings, ugi, config);
        }
        if (!gotMountTableEntry) {
            throw new IOException("ViewFs: Cannot initialize: Empty Mount table in config for viewfs://" + vName + "/");
        }
    }

    ResolveResult<T> resolve(String p, boolean resolveLastComponent) throws FileNotFoundException {
        Path remainingPath;
        int i;
        String[] path = InodeTree.breakIntoPathComponents(p);
        if (path.length <= 1) {
            ResolveResult res = new ResolveResult(ResultKind.INTERNAL_DIR, this.root.InodeDirFs, this.root.fullPath, SlashPath);
            return res;
        }
        INodeDir curInode = this.root;
        for (i = 1; i < path.length - (resolveLastComponent ? 0 : 1); ++i) {
            INode<T> nextInode = curInode.resolveInternal(path[i]);
            if (nextInode == null) {
                StringBuilder failedAt = new StringBuilder(path[0]);
                for (int j = 1; j <= i; ++j) {
                    failedAt.append('/').append(path[j]);
                }
                throw new FileNotFoundException("File/Directory does not exist: " + failedAt.toString());
            }
            if (nextInode instanceof INodeLink) {
                Path remainingPath2;
                INodeLink link = (INodeLink)nextInode;
                if (i >= path.length - 1) {
                    remainingPath2 = SlashPath;
                } else {
                    StringBuilder remainingPathStr = new StringBuilder("/" + path[i + 1]);
                    for (int j = i + 2; j < path.length; ++j) {
                        remainingPathStr.append('/').append(path[j]);
                    }
                    remainingPath2 = new Path(remainingPathStr.toString());
                }
                ResolveResult res = new ResolveResult(ResultKind.EXTERNAL_DIR, link.targetFileSystem, nextInode.fullPath, remainingPath2);
                return res;
            }
            if (!(nextInode instanceof INodeDir)) continue;
            curInode = (INodeDir)nextInode;
        }
        if (resolveLastComponent) {
            remainingPath = SlashPath;
        } else {
            StringBuilder remainingPathStr = new StringBuilder("/" + path[i]);
            for (int j = i + 1; j < path.length; ++j) {
                remainingPathStr.append('/').append(path[j]);
            }
            remainingPath = new Path(remainingPathStr.toString());
        }
        ResolveResult res = new ResolveResult(ResultKind.INTERNAL_DIR, curInode.InodeDirFs, curInode.fullPath, remainingPath);
        return res;
    }

    List<MountPoint<T>> getMountPoints() {
        return this.mountPoints;
    }

    String getHomeDirPrefixValue() {
        return this.homedirPrefix;
    }

    static class ResolveResult<T> {
        final ResultKind kind;
        final T targetFileSystem;
        final String resolvedPath;
        final Path remainingPath;

        ResolveResult(ResultKind k, T targetFs, String resolveP, Path remainingP) {
            this.kind = k;
            this.targetFileSystem = targetFs;
            this.resolvedPath = resolveP;
            this.remainingPath = remainingP;
        }

        boolean isInternalDir() {
            return this.kind == ResultKind.INTERNAL_DIR;
        }
    }

    static class INodeLink<T>
    extends INode<T> {
        final URI[] targetDirLinkList;
        final T targetFileSystem;

        INodeLink(String pathToNode, UserGroupInformation aUgi, T targetMergeFs, URI[] aTargetDirLinkList) {
            super(pathToNode, aUgi);
            this.targetFileSystem = targetMergeFs;
            this.targetDirLinkList = aTargetDirLinkList;
        }

        INodeLink(String pathToNode, UserGroupInformation aUgi, T targetFs, URI aTargetDirLink) {
            super(pathToNode, aUgi);
            this.targetFileSystem = targetFs;
            this.targetDirLinkList = new URI[1];
            this.targetDirLinkList[0] = aTargetDirLink;
        }

        Path getTargetLink() {
            StringBuilder result = new StringBuilder(this.targetDirLinkList[0].toString());
            for (int i = 1; i < this.targetDirLinkList.length; ++i) {
                result.append(',').append(this.targetDirLinkList[i].toString());
            }
            return new Path(result.toString());
        }
    }

    static enum LinkType {
        SINGLE,
        MERGE,
        NFLY;

    }

    static class INodeDir<T>
    extends INode<T> {
        final Map<String, INode<T>> children = new HashMap<String, INode<T>>();
        T InodeDirFs = null;
        boolean isRoot = false;

        INodeDir(String pathToNode, UserGroupInformation aUgi) {
            super(pathToNode, aUgi);
        }

        INode<T> resolveInternal(String pathComponent) {
            return this.children.get(pathComponent);
        }

        INodeDir<T> addDir(String pathComponent, UserGroupInformation aUgi) throws FileAlreadyExistsException {
            if (this.children.containsKey(pathComponent)) {
                throw new FileAlreadyExistsException();
            }
            INodeDir<T> newDir = new INodeDir<T>(this.fullPath + (this.isRoot ? "" : "/") + pathComponent, aUgi);
            this.children.put(pathComponent, newDir);
            return newDir;
        }

        void addLink(String pathComponent, INodeLink<T> link) throws FileAlreadyExistsException {
            if (this.children.containsKey(pathComponent)) {
                throw new FileAlreadyExistsException();
            }
            this.children.put(pathComponent, link);
        }
    }

    static abstract class INode<T> {
        final String fullPath;

        public INode(String pathToNode, UserGroupInformation aUgi) {
            this.fullPath = pathToNode;
        }
    }

    static class MountPoint<T> {
        String src;
        INodeLink<T> target;

        MountPoint(String srcPath, INodeLink<T> mountLink) {
            this.src = srcPath;
            this.target = mountLink;
        }
    }

    static enum ResultKind {
        INTERNAL_DIR,
        EXTERNAL_DIR;

    }
}

