/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.curator;

import java.io.Closeable;
import java.net.BindException;
import java.util.Random;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.locks.Reaper;
import org.apache.curator.retry.RetryOneTime;
import org.apache.curator.test.TestingServer;
import org.apache.curator.test.Timing;
import org.apache.curator.utils.CloseableUtils;
import org.apache.hadoop.util.curator.ChildReaper;
import org.apache.zookeeper.data.Stat;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestChildReaper {
    protected TestingServer server;

    @Before
    public void setup() throws Exception {
        while (this.server == null) {
            try {
                this.server = new TestingServer();
            }
            catch (BindException var2) {
                System.err.println("Getting bind exception - retrying to allocate server");
                this.server = null;
            }
        }
    }

    @After
    public void teardown() throws Exception {
        this.server.close();
        this.server = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSomeNodes() throws Exception {
        Timing timing = new Timing();
        ChildReaper reaper = null;
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)this.server.getConnectString(), (int)timing.session(), (int)timing.connection(), (RetryPolicy)new RetryOneTime(1));
        try {
            client.start();
            Random r = new Random();
            int nonEmptyNodes = 0;
            for (int i = 0; i < 10; ++i) {
                client.create().creatingParentsIfNeeded().forPath("/test/" + Integer.toString(i));
                if (!r.nextBoolean()) continue;
                client.create().forPath("/test/" + Integer.toString(i) + "/foo");
                ++nonEmptyNodes;
            }
            reaper = new ChildReaper(client, "/test", Reaper.Mode.REAP_UNTIL_DELETE, 1);
            reaper.start();
            timing.forWaiting().sleepABit();
            Stat stat = (Stat)client.checkExists().forPath("/test");
            Assertions.assertThat((int)stat.getNumChildren()).isEqualTo(nonEmptyNodes);
        }
        catch (Throwable throwable) {
            CloseableUtils.closeQuietly(reaper);
            CloseableUtils.closeQuietly((Closeable)client);
            throw throwable;
        }
        CloseableUtils.closeQuietly((Closeable)reaper);
        CloseableUtils.closeQuietly((Closeable)client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimple() throws Exception {
        Timing timing = new Timing();
        ChildReaper reaper = null;
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)this.server.getConnectString(), (int)timing.session(), (int)timing.connection(), (RetryPolicy)new RetryOneTime(1));
        try {
            client.start();
            for (int i = 0; i < 10; ++i) {
                client.create().creatingParentsIfNeeded().forPath("/test/" + Integer.toString(i));
            }
            reaper = new ChildReaper(client, "/test", Reaper.Mode.REAP_UNTIL_DELETE, 1);
            reaper.start();
            timing.forWaiting().sleepABit();
            Stat stat = (Stat)client.checkExists().forPath("/test");
            Assertions.assertThat((int)stat.getNumChildren()).isZero();
        }
        catch (Throwable throwable) {
            CloseableUtils.closeQuietly(reaper);
            CloseableUtils.closeQuietly((Closeable)client);
            throw throwable;
        }
        CloseableUtils.closeQuietly((Closeable)reaper);
        CloseableUtils.closeQuietly((Closeable)client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiPath() throws Exception {
        Timing timing = new Timing();
        ChildReaper reaper = null;
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)this.server.getConnectString(), (int)timing.session(), (int)timing.connection(), (RetryPolicy)new RetryOneTime(1));
        try {
            client.start();
            for (int i = 0; i < 10; ++i) {
                client.create().creatingParentsIfNeeded().forPath("/test1/" + Integer.toString(i));
                client.create().creatingParentsIfNeeded().forPath("/test2/" + Integer.toString(i));
                client.create().creatingParentsIfNeeded().forPath("/test3/" + Integer.toString(i));
            }
            reaper = new ChildReaper(client, "/test2", Reaper.Mode.REAP_UNTIL_DELETE, 1);
            reaper.start();
            reaper.addPath("/test1");
            timing.forWaiting().sleepABit();
            Stat stat = (Stat)client.checkExists().forPath("/test1");
            Assertions.assertThat((int)stat.getNumChildren()).isZero();
            stat = (Stat)client.checkExists().forPath("/test2");
            Assertions.assertThat((int)stat.getNumChildren()).isZero();
            stat = (Stat)client.checkExists().forPath("/test3");
            Assertions.assertThat((int)stat.getNumChildren()).isEqualTo(10);
        }
        catch (Throwable throwable) {
            CloseableUtils.closeQuietly(reaper);
            CloseableUtils.closeQuietly((Closeable)client);
            throw throwable;
        }
        CloseableUtils.closeQuietly((Closeable)reaper);
        CloseableUtils.closeQuietly((Closeable)client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamespace() throws Exception {
        Timing timing = new Timing();
        ChildReaper reaper = null;
        CuratorFramework client = CuratorFrameworkFactory.builder().connectString(this.server.getConnectString()).sessionTimeoutMs(timing.session()).connectionTimeoutMs(timing.connection()).retryPolicy((RetryPolicy)new RetryOneTime(1)).namespace("foo").build();
        try {
            client.start();
            for (int i = 0; i < 10; ++i) {
                client.create().creatingParentsIfNeeded().forPath("/test/" + Integer.toString(i));
            }
            reaper = new ChildReaper(client, "/test", Reaper.Mode.REAP_UNTIL_DELETE, 1);
            reaper.start();
            timing.forWaiting().sleepABit();
            Stat stat = (Stat)client.checkExists().forPath("/test");
            Assertions.assertThat((int)stat.getNumChildren()).isZero();
            stat = (Stat)client.usingNamespace(null).checkExists().forPath("/foo/test");
            Assertions.assertThat((Object)stat).isNotNull();
            Assertions.assertThat((int)stat.getNumChildren()).isZero();
        }
        catch (Throwable throwable) {
            CloseableUtils.closeQuietly(reaper);
            CloseableUtils.closeQuietly((Closeable)client);
            throw throwable;
        }
        CloseableUtils.closeQuietly((Closeable)reaper);
        CloseableUtils.closeQuietly((Closeable)client);
    }
}

