/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@Metrics(about="Aggregate RPC metrics", context="rpc")
public class RpcMetrics {
    static final Logger LOG = LoggerFactory.getLogger(RpcMetrics.class);
    final Server server;
    final MetricsRegistry registry;
    final String name;
    final boolean rpcQuantileEnable;
    public static final TimeUnit DEFAULT_METRIC_TIME_UNIT = TimeUnit.MILLISECONDS;
    private final TimeUnit metricsTimeUnit;
    @Metric(value={"Number of received bytes"})
    MutableCounterLong receivedBytes;
    @Metric(value={"Number of sent bytes"})
    MutableCounterLong sentBytes;
    @Metric(value={"Queue time"})
    MutableRate rpcQueueTime;
    MutableQuantiles[] rpcQueueTimeQuantiles;
    @Metric(value={"Lock wait time"})
    MutableRate rpcLockWaitTime;
    MutableQuantiles[] rpcLockWaitTimeQuantiles;
    @Metric(value={"Processing time"})
    MutableRate rpcProcessingTime;
    MutableQuantiles[] rpcProcessingTimeQuantiles;
    @Metric(value={"Deferred Processing time"})
    MutableRate deferredRpcProcessingTime;
    MutableQuantiles[] deferredRpcProcessingTimeQuantiles;
    @Metric(value={"Number of authentication failures"})
    MutableCounterLong rpcAuthenticationFailures;
    @Metric(value={"Number of authentication successes"})
    MutableCounterLong rpcAuthenticationSuccesses;
    @Metric(value={"Number of authorization failures"})
    MutableCounterLong rpcAuthorizationFailures;
    @Metric(value={"Number of authorization successes"})
    MutableCounterLong rpcAuthorizationSuccesses;
    @Metric(value={"Number of client backoff requests"})
    MutableCounterLong rpcClientBackoff;
    @Metric(value={"Number of Slow RPC calls"})
    MutableCounterLong rpcSlowCalls;

    RpcMetrics(Server server, Configuration conf) {
        String port = String.valueOf(server.getListenerAddress().getPort());
        this.name = "RpcActivityForPort" + port;
        this.server = server;
        this.registry = new MetricsRegistry("rpc").tag("port", "RPC port", port).tag("serverName", "Name of the RPC server", server.getServerName());
        int[] intervals = conf.getInts("rpc.metrics.percentiles.intervals");
        this.rpcQuantileEnable = intervals.length > 0 && conf.getBoolean("rpc.metrics.quantile.enable", false);
        this.metricsTimeUnit = RpcMetrics.getMetricsTimeUnit(conf);
        if (this.rpcQuantileEnable) {
            this.rpcQueueTimeQuantiles = new MutableQuantiles[intervals.length];
            this.rpcLockWaitTimeQuantiles = new MutableQuantiles[intervals.length];
            this.rpcProcessingTimeQuantiles = new MutableQuantiles[intervals.length];
            this.deferredRpcProcessingTimeQuantiles = new MutableQuantiles[intervals.length];
            for (int i = 0; i < intervals.length; ++i) {
                int interval = intervals[i];
                this.rpcQueueTimeQuantiles[i] = this.registry.newQuantiles("rpcQueueTime" + interval + "s", "rpc queue time in " + (Object)((Object)this.metricsTimeUnit), "ops", "latency", interval);
                this.rpcLockWaitTimeQuantiles[i] = this.registry.newQuantiles("rpcLockWaitTime" + interval + "s", "rpc lock wait time in " + (Object)((Object)this.metricsTimeUnit), "ops", "latency", interval);
                this.rpcProcessingTimeQuantiles[i] = this.registry.newQuantiles("rpcProcessingTime" + interval + "s", "rpc processing time in " + (Object)((Object)this.metricsTimeUnit), "ops", "latency", interval);
                this.deferredRpcProcessingTimeQuantiles[i] = this.registry.newQuantiles("deferredRpcProcessingTime" + interval + "s", "deferred rpc processing time in " + (Object)((Object)this.metricsTimeUnit), "ops", "latency", interval);
            }
        }
        LOG.debug("Initialized " + this.registry);
    }

    public String name() {
        return this.name;
    }

    public static RpcMetrics create(Server server, Configuration conf) {
        RpcMetrics m = new RpcMetrics(server, conf);
        return DefaultMetricsSystem.instance().register(m.name, null, m);
    }

    @Metric(value={"Number of open connections"})
    public int numOpenConnections() {
        return this.server.getNumOpenConnections();
    }

    @Metric(value={"Number of open connections per user"})
    public String numOpenConnectionsPerUser() {
        return this.server.getNumOpenConnectionsPerUser();
    }

    @Metric(value={"Length of the call queue"})
    public int callQueueLength() {
        return this.server.getCallQueueLen();
    }

    @Metric(value={"Number of dropped connections"})
    public long numDroppedConnections() {
        return this.server.getNumDroppedConnections();
    }

    public TimeUnit getMetricsTimeUnit() {
        return this.metricsTimeUnit;
    }

    public static TimeUnit getMetricsTimeUnit(Configuration conf) {
        TimeUnit metricsTimeUnit = DEFAULT_METRIC_TIME_UNIT;
        String timeunit = conf.get("rpc.metrics.timeunit");
        if (StringUtils.isNotEmpty((CharSequence)timeunit)) {
            try {
                metricsTimeUnit = TimeUnit.valueOf(timeunit);
            }
            catch (IllegalArgumentException e) {
                LOG.info("Config key {} 's value {} does not correspond to enum values of java.util.concurrent.TimeUnit. Hence default unit {} will be used", new Object[]{"rpc.metrics.timeunit", timeunit, DEFAULT_METRIC_TIME_UNIT});
            }
        }
        return metricsTimeUnit;
    }

    public void incrAuthenticationFailures() {
        this.rpcAuthenticationFailures.incr();
    }

    public void incrAuthenticationSuccesses() {
        this.rpcAuthenticationSuccesses.incr();
    }

    public void incrAuthorizationSuccesses() {
        this.rpcAuthorizationSuccesses.incr();
    }

    public void incrAuthorizationFailures() {
        this.rpcAuthorizationFailures.incr();
    }

    public void shutdown() {
        DefaultMetricsSystem.instance().unregisterSource(this.name);
    }

    public void incrSentBytes(int count) {
        this.sentBytes.incr(count);
    }

    public void incrReceivedBytes(int count) {
        this.receivedBytes.incr(count);
    }

    public void addRpcQueueTime(long qTime) {
        this.rpcQueueTime.add(qTime);
        if (this.rpcQuantileEnable) {
            for (MutableQuantiles q : this.rpcQueueTimeQuantiles) {
                q.add(qTime);
            }
        }
    }

    public void addRpcLockWaitTime(long waitTime) {
        this.rpcLockWaitTime.add(waitTime);
        if (this.rpcQuantileEnable) {
            for (MutableQuantiles q : this.rpcLockWaitTimeQuantiles) {
                q.add(waitTime);
            }
        }
    }

    public void addRpcProcessingTime(long processingTime) {
        this.rpcProcessingTime.add(processingTime);
        if (this.rpcQuantileEnable) {
            for (MutableQuantiles q : this.rpcProcessingTimeQuantiles) {
                q.add(processingTime);
            }
        }
    }

    public void addDeferredRpcProcessingTime(long processingTime) {
        this.deferredRpcProcessingTime.add(processingTime);
        if (this.rpcQuantileEnable) {
            for (MutableQuantiles q : this.deferredRpcProcessingTimeQuantiles) {
                q.add(processingTime);
            }
        }
    }

    public void incrClientBackoff() {
        this.rpcClientBackoff.incr();
    }

    public void incrSlowRpc() {
        this.rpcSlowCalls.incr();
    }

    public MutableRate getRpcProcessingTime() {
        return this.rpcProcessingTime;
    }

    public long getProcessingSampleCount() {
        return this.rpcProcessingTime.lastStat().numSamples();
    }

    public double getProcessingMean() {
        return this.rpcProcessingTime.lastStat().mean();
    }

    public double getProcessingStdDev() {
        return this.rpcProcessingTime.lastStat().stddev();
    }

    public long getRpcSlowCalls() {
        return this.rpcSlowCalls.value();
    }

    public MutableRate getDeferredRpcProcessingTime() {
        return this.deferredRpcProcessingTime;
    }

    public long getDeferredRpcProcessingSampleCount() {
        return this.deferredRpcProcessingTime.lastStat().numSamples();
    }

    public double getDeferredRpcProcessingMean() {
        return this.deferredRpcProcessingTime.lastStat().mean();
    }

    public double getDeferredRpcProcessingStdDev() {
        return this.deferredRpcProcessingTime.lastStat().stddev();
    }

    @VisibleForTesting
    public MetricsTag getTag(String tagName) {
        return this.registry.getTag(tagName);
    }
}

