/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.util.ExitUtil;

@InterfaceAudience.Private
public final class Classpath {
    private static final String usage = "classpath [--glob|--jar <path>|-h|--help] :\n  Prints the classpath needed to get the Hadoop jar and the required\n  libraries.\n  Options:\n\n  --glob       expand wildcards\n  --jar <path> write classpath as manifest in jar named <path>\n  -h, --help   print help\n";

    public static void main(String[] args) {
        if (args.length < 1 || args[0].equals("-h") || args[0].equals("--help")) {
            System.out.println(usage);
            return;
        }
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        CommandFormat cf = new CommandFormat(0, Integer.MAX_VALUE, "-glob", "-jar");
        try {
            cf.parse(argsList);
        }
        catch (CommandFormat.UnknownOptionException e) {
            Classpath.terminate(1, "unrecognized option");
            return;
        }
        String classPath = System.getProperty("java.class.path");
        if (cf.getOpt("-glob")) {
            System.out.println(classPath);
        } else if (cf.getOpt("-jar")) {
            String tmpJarPath;
            if (argsList.isEmpty() || argsList.get(0) == null || ((String)argsList.get(0)).isEmpty()) {
                Classpath.terminate(1, "-jar option requires path of jar file to write");
                return;
            }
            Path workingDir = new Path(System.getProperty("user.dir"));
            try {
                tmpJarPath = FileUtil.createJarWithClassPath(classPath, workingDir, System.getenv())[0];
            }
            catch (IOException e) {
                Classpath.terminate(1, "I/O error creating jar: " + e.getMessage());
                return;
            }
            String jarPath = (String)argsList.get(0);
            try {
                FileUtil.replaceFile(new File(tmpJarPath), new File(jarPath));
            }
            catch (IOException e) {
                Classpath.terminate(1, "I/O error renaming jar temporary file to path: " + e.getMessage());
                return;
            }
        }
    }

    private static void terminate(int status, String msg) {
        System.err.println(msg);
        ExitUtil.terminate(status, msg);
    }
}

