/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDFSUpgradeFromImage;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.test.GenericTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class TestDatanodeStartupFixesLegacyStorageIDs {
    private static void runLayoutUpgradeTest(String testCaseName, final String expectedStorageId) throws IOException {
        TestDFSUpgradeFromImage upgrade = new TestDFSUpgradeFromImage();
        upgrade.unpackStorage(testCaseName + ".tgz", testCaseName + ".txt");
        Configuration conf = new Configuration(TestDFSUpgradeFromImage.upgradeConf);
        TestDatanodeStartupFixesLegacyStorageIDs.initStorageDirs(conf, testCaseName);
        TestDatanodeStartupFixesLegacyStorageIDs.upgradeAndVerify(upgrade, conf, new TestDFSUpgradeFromImage.ClusterVerifier(){

            @Override
            public void verifyClusterPostUpgrade(MiniDFSCluster cluster) throws IOException {
                String bpid = cluster.getNamesystem().getBlockPoolId();
                StorageReport[] reports = cluster.getDataNodes().get(0).getFSDataset().getStorageReports(bpid);
                Assert.assertThat((Object)reports.length, (Matcher)Is.is((Object)1));
                String storageID = reports[0].getStorage().getStorageID();
                Assert.assertTrue((boolean)DatanodeStorage.isValidStorageId((String)storageID));
                if (expectedStorageId != null) {
                    Assert.assertThat((Object)storageID, (Matcher)Is.is((Object)expectedStorageId));
                }
            }
        });
    }

    private static void initStorageDirs(Configuration conf, String testName) {
        conf.set("dfs.datanode.data.dir", GenericTestUtils.getTempPath((String)(testName + File.separator + "dfs" + File.separator + "data")));
        conf.set("dfs.namenode.name.dir", GenericTestUtils.getTempPath((String)(testName + File.separator + "dfs" + File.separator + "name")));
    }

    private static void upgradeAndVerify(TestDFSUpgradeFromImage upgrade, Configuration conf, TestDFSUpgradeFromImage.ClusterVerifier verifier) throws IOException {
        upgrade.upgradeAndVerify(new MiniDFSCluster.Builder(conf).numDataNodes(1).manageDataDfsDirs(false).manageNameDfsDirs(false), verifier);
    }

    @Test(timeout=300000L)
    public void testUpgradeFrom22FixesStorageIDs() throws IOException {
        TestDatanodeStartupFixesLegacyStorageIDs.runLayoutUpgradeTest(GenericTestUtils.getMethodName(), null);
    }

    @Test(timeout=300000L)
    public void testUpgradeFrom22via26FixesStorageIDs() throws IOException {
        TestDatanodeStartupFixesLegacyStorageIDs.runLayoutUpgradeTest(GenericTestUtils.getMethodName(), null);
    }

    @Test(timeout=300000L)
    public void testUpgradeFrom26PreservesStorageIDs() throws IOException {
        TestDatanodeStartupFixesLegacyStorageIDs.runLayoutUpgradeTest(GenericTestUtils.getMethodName(), "DS-a0e39cfa-930f-4abd-813c-e22b59223774");
    }
}

