/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.base.Supplier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeList;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReservedSpaceCalculator;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFsVolumeList {
    private Configuration conf;
    private VolumeChoosingPolicy<FsVolumeImpl> blockChooser = new RoundRobinVolumeChoosingPolicy();
    private FsDatasetImpl dataset = null;
    private String baseDir;
    private BlockScanner blockScanner;

    @Before
    public void setUp() {
        this.dataset = (FsDatasetImpl)Mockito.mock(FsDatasetImpl.class);
        this.baseDir = new FileSystemTestHelper().getTestRootDir();
        Configuration blockScannerConf = new Configuration();
        blockScannerConf.setInt("dfs.datanode.scan.period.hours", -1);
        this.blockScanner = new BlockScanner(null, blockScannerConf);
        this.conf = new Configuration();
    }

    @Test(timeout=30000L)
    public void testGetNextVolumeWithClosedVolume() throws IOException {
        FsVolumeList volumeList = new FsVolumeList(Collections.emptyList(), this.blockScanner, this.blockChooser);
        final ArrayList<FsVolumeImpl> volumes = new ArrayList<FsVolumeImpl>();
        for (int i = 0; i < 3; ++i) {
            File curDir = new File(this.baseDir, "nextvolume-" + i);
            curDir.mkdirs();
            FsVolumeImpl volume = new FsVolumeImpl(this.dataset, "storage-id", curDir, this.conf, StorageType.DEFAULT);
            volume.setCapacityForTesting(0x40000000L);
            volumes.add(volume);
            volumeList.addVolume(volume.obtainReference());
        }
        ((FsVolumeImpl)volumes.get(1)).setClosed();
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return ((FsVolumeImpl)volumes.get(1)).checkClosed();
                }
            }, (int)100, (int)3000);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"timed out while waiting for volume to be removed.");
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        for (int i = 0; i < 10; ++i) {
            try (FsVolumeReference ref = volumeList.getNextVolume(StorageType.DEFAULT, 128L);){
                Assert.assertNotEquals((Object)ref.getVolume(), volumes.get(1));
                continue;
            }
        }
    }

    @Test(timeout=30000L)
    public void testReleaseVolumeRefIfNoBlockScanner() throws IOException {
        FsVolumeList volumeList = new FsVolumeList(Collections.emptyList(), null, this.blockChooser);
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        FsVolumeImpl volume = new FsVolumeImpl(this.dataset, "storage-id", volDir, this.conf, StorageType.DEFAULT);
        FsVolumeReference ref = volume.obtainReference();
        volumeList.addVolume(ref);
        Assert.assertNull((Object)ref.getVolume());
    }

    @Test
    public void testDfsReservedForDifferentStorageTypes() throws IOException {
        Configuration conf = new Configuration();
        conf.setLong("dfs.datanode.du.reserved", 100L);
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        FsVolumeImpl volume = new FsVolumeImpl(this.dataset, "storage-id", volDir, conf, StorageType.RAM_DISK);
        Assert.assertEquals((String)"", (long)100L, (long)volume.getReserved());
        conf.setLong("dfs.datanode.du.reserved." + StringUtils.toLowerCase((String)StorageType.RAM_DISK.toString()), 1L);
        conf.setLong("dfs.datanode.du.reserved." + StringUtils.toLowerCase((String)StorageType.SSD.toString()), 2L);
        FsVolumeImpl volume1 = new FsVolumeImpl(this.dataset, "storage-id", volDir, conf, StorageType.RAM_DISK);
        Assert.assertEquals((String)"", (long)1L, (long)volume1.getReserved());
        FsVolumeImpl volume2 = new FsVolumeImpl(this.dataset, "storage-id", volDir, conf, StorageType.SSD);
        Assert.assertEquals((String)"", (long)2L, (long)volume2.getReserved());
        FsVolumeImpl volume3 = new FsVolumeImpl(this.dataset, "storage-id", volDir, conf, StorageType.DISK);
        Assert.assertEquals((String)"", (long)100L, (long)volume3.getReserved());
        FsVolumeImpl volume4 = new FsVolumeImpl(this.dataset, "storage-id", volDir, conf, StorageType.DEFAULT);
        Assert.assertEquals((String)"", (long)100L, (long)volume4.getReserved());
    }

    @Test
    public void testNonDfsUsedMetricForVolume() throws Exception {
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        long diskCapacity = 1000L;
        long duReserved = 100L;
        long dfsUsage = 200L;
        long actualNonDfsUsage = 300L;
        long reservedForReplicas = 50L;
        this.conf.setLong("dfs.datanode.du.reserved", duReserved);
        FsVolumeImpl volume = new FsVolumeImpl(this.dataset, "storage-id", volDir, this.conf, StorageType.DEFAULT);
        FsVolumeImpl spyVolume = (FsVolumeImpl)Mockito.spy((Object)volume);
        long testCapacity = diskCapacity - duReserved;
        spyVolume.setCapacityForTesting(testCapacity);
        long dfAvailable = diskCapacity - dfsUsage - actualNonDfsUsage;
        ((FsVolumeImpl)Mockito.doReturn((Object)dfAvailable).when((Object)spyVolume)).getDfAvailable();
        ((FsVolumeImpl)Mockito.doReturn((Object)dfsUsage).when((Object)spyVolume)).getDfsUsed();
        ((FsVolumeImpl)Mockito.doReturn((Object)reservedForReplicas).when((Object)spyVolume)).getReservedForReplicas();
        ((FsVolumeImpl)Mockito.doReturn((Object)actualNonDfsUsage).when((Object)spyVolume)).getActualNonDfsUsed();
        long expectedNonDfsUsage = actualNonDfsUsage - duReserved;
        Assert.assertEquals((long)expectedNonDfsUsage, (long)spyVolume.getNonDfsUsed());
    }

    @Test
    public void testDfsReservedPercentageForDifferentStorageTypes() throws IOException {
        this.conf.setClass("dfs.datanode.du.reserved.calculator", ReservedSpaceCalculator.ReservedSpaceCalculatorPercentage.class, ReservedSpaceCalculator.class);
        this.conf.setLong("dfs.datanode.du.reserved.pct", 15L);
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        DF usage = (DF)Mockito.mock(DF.class);
        Mockito.when((Object)usage.getCapacity()).thenReturn((Object)4000L);
        Mockito.when((Object)usage.getAvailable()).thenReturn((Object)1000L);
        FsVolumeImpl volume = new FsVolumeImpl(this.dataset, "storage-id", volDir, this.conf, StorageType.RAM_DISK, usage);
        Assert.assertEquals((long)600L, (long)volume.getReserved());
        Assert.assertEquals((long)3400L, (long)volume.getCapacity());
        Assert.assertEquals((long)400L, (long)volume.getAvailable());
        this.conf.setLong("dfs.datanode.du.reserved.pct." + StringUtils.toLowerCase((String)StorageType.RAM_DISK.toString()), 10L);
        this.conf.setLong("dfs.datanode.du.reserved.pct." + StringUtils.toLowerCase((String)StorageType.SSD.toString()), 50L);
        FsVolumeImpl volume1 = new FsVolumeImpl(this.dataset, "storage-id", volDir, this.conf, StorageType.RAM_DISK, usage);
        Assert.assertEquals((long)400L, (long)volume1.getReserved());
        Assert.assertEquals((long)3600L, (long)volume1.getCapacity());
        Assert.assertEquals((long)600L, (long)volume1.getAvailable());
        FsVolumeImpl volume2 = new FsVolumeImpl(this.dataset, "storage-id", volDir, this.conf, StorageType.SSD, usage);
        Assert.assertEquals((long)2000L, (long)volume2.getReserved());
        Assert.assertEquals((long)2000L, (long)volume2.getCapacity());
        Assert.assertEquals((long)0L, (long)volume2.getAvailable());
        FsVolumeImpl volume3 = new FsVolumeImpl(this.dataset, "storage-id", volDir, this.conf, StorageType.DISK, usage);
        Assert.assertEquals((long)600L, (long)volume3.getReserved());
        FsVolumeImpl volume4 = new FsVolumeImpl(this.dataset, "storage-id", volDir, this.conf, StorageType.ARCHIVE, usage);
        Assert.assertEquals((long)600L, (long)volume4.getReserved());
    }

    @Test(timeout=60000L)
    public void testAddRplicaProcessorForAddingReplicaInMap() throws Exception {
        Configuration cnf = new Configuration();
        int poolSize = 5;
        cnf.setInt("dfs.replication", 1);
        cnf.setInt("dfs.datanode.volumes.replica-add.threadpool.size", poolSize);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(cnf).numDataNodes(1).storagesPerDatanode(1).build();
        final DistributedFileSystem fs = cluster.getFileSystem();
        ExecutorService pool = Executors.newFixedThreadPool(10);
        ArrayList futureList = new ArrayList();
        for (int i = 0; i < 100; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    for (int j = 0; j < 10; ++j) {
                        try {
                            DFSTestUtil.createFile((FileSystem)fs, new Path("File_" + this.getName() + j), 10L, (short)1, 0L);
                            continue;
                        }
                        catch (IOException | IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            thread.setName("FileWriter" + i);
            futureList.add(pool.submit(thread));
        }
        for (Future future : futureList) {
            future.get();
        }
        fs.close();
        FsDatasetImpl fsDataset = (FsDatasetImpl)cluster.getDataNodes().get(0).getFSDataset();
        ReplicaMap replicaMap = new ReplicaMap(new AutoCloseableLock());
        RamDiskReplicaTracker ramDiskReplicaMap = RamDiskReplicaTracker.getInstance((Configuration)this.conf, (FsDatasetImpl)fsDataset);
        FsVolumeImpl vol = (FsVolumeImpl)fsDataset.getFsVolumeReferences().get(0);
        String bpid = cluster.getNamesystem().getBlockPoolId();
        vol.getVolumeMap(bpid, replicaMap, ramDiskReplicaMap);
        Assert.assertTrue((String)"Failed to add all the replica to map", (replicaMap.replicas(bpid).size() == 1000 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Fork pool size should be " + poolSize), (BlockPoolSlice.getAddReplicaForkPoolSize() == poolSize ? 1 : 0) != 0);
    }
}

