/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.namenode.FSImageCompression;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.SaveNamespaceContext;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.hdfs.util.Canceler;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSImageWithSnapshot {
    static final long seed = 0L;
    static final short NUM_DATANODES = 1;
    static final int BLOCKSIZE = 1024;
    static final long txid = 1L;
    private final Path dir;
    private static final String testDir = GenericTestUtils.getTestDir().getAbsolutePath();
    Configuration conf;
    MiniDFSCluster cluster;
    FSNamesystem fsn;
    DistributedFileSystem hdfs;
    private final PrintWriter output;
    private int printTreeCount;

    public TestFSImageWithSnapshot() {
        SnapshotTestHelper.disableLogs();
        GenericTestUtils.setLogLevel((Log)INode.LOG, (Level)Level.ALL);
        this.dir = new Path("/TestSnapshot");
        this.output = new PrintWriter(System.out, true);
        this.printTreeCount = 0;
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private File getImageFile(String dir, long imageTxId) {
        return new File(dir, String.format("%s_%019d", NNStorage.NameNodeFile.IMAGE, imageTxId));
    }

    private File getDumpTreeFile(String dir, String suffix) {
        return new File(dir, String.format("dumpTree_%s", suffix));
    }

    private File dumpTree2File(String fileSuffix) throws IOException {
        File file = this.getDumpTreeFile(testDir, fileSuffix);
        SnapshotTestHelper.dumpTree2File(this.fsn.getFSDirectory(), file);
        return file;
    }

    private HdfsDataOutputStream appendFileWithoutClosing(Path file, int length) throws IOException {
        byte[] toAppend = new byte[length];
        Random random = new Random();
        random.nextBytes(toAppend);
        HdfsDataOutputStream out = (HdfsDataOutputStream)this.hdfs.append(file);
        out.write(toAppend);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File saveFSImageToTempFile() throws IOException {
        SaveNamespaceContext context = new SaveNamespaceContext(this.fsn, 1L, new Canceler());
        FSImageFormatProtobuf.Saver saver = new FSImageFormatProtobuf.Saver(context, this.conf);
        FSImageCompression compression = FSImageCompression.createCompression((Configuration)this.conf);
        File imageFile = this.getImageFile(testDir, 1L);
        this.fsn.readLock();
        try {
            saver.save(imageFile, compression);
        }
        finally {
            this.fsn.readUnlock();
        }
        return imageFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFSImageFromTempFile(File imageFile) throws IOException {
        FSImageFormat.LoaderDelegator loader = FSImageFormat.newLoader((Configuration)this.conf, (FSNamesystem)this.fsn);
        this.fsn.writeLock();
        this.fsn.getFSDirectory().writeLock();
        try {
            loader.load(imageFile, false);
            this.fsn.getFSDirectory().updateCountForQuota();
        }
        finally {
            this.fsn.getFSDirectory().writeUnlock();
            this.fsn.writeUnlock();
        }
    }

    @Test
    public void testSnapshotOnRoot() throws Exception {
        Path root = new Path("/");
        this.hdfs.allowSnapshot(root);
        this.hdfs.createSnapshot(root, "s1");
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        this.hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        INodeDirectory rootNode = this.fsn.dir.getINode4Write(root.toString()).asDirectory();
        Assert.assertTrue((String)"The children list of root should be empty", (boolean)rootNode.getChildrenList(0x7FFFFFFE).isEmpty());
        List diffList = rootNode.getDiffs().asList();
        Assert.assertEquals((long)1L, (long)diffList.size());
        Snapshot s1 = rootNode.getSnapshot(DFSUtil.string2Bytes((String)"s1"));
        Assert.assertEquals((long)s1.getId(), (long)((DirectoryWithSnapshotFeature.DirectoryDiff)diffList.get(0)).getSnapshotId());
        Assert.assertEquals((long)1L, (long)this.fsn.getSnapshotManager().getNumSnapshottableDirs());
        SnapshottableDirectoryStatus[] sdirs = this.fsn.getSnapshotManager().getSnapshottableDirListing(null);
        Assert.assertEquals((Object)root, (Object)sdirs[0].getFullPath());
        this.hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
    }

    @Test
    public void testSaveLoadImage() throws Exception {
        int s = 0;
        this.hdfs.mkdirs(this.dir);
        SnapshotTestHelper.createSnapshot(this.hdfs, this.dir, "s" + ++s);
        Path sub1 = new Path(this.dir, "sub1");
        this.hdfs.mkdirs(sub1);
        this.hdfs.setPermission(sub1, new FsPermission(511));
        Path sub11 = new Path(sub1, "sub11");
        this.hdfs.mkdirs(sub11);
        this.checkImage(s);
        this.hdfs.createSnapshot(this.dir, "s" + ++s);
        Path sub1file1 = new Path(sub1, "sub1file1");
        Path sub1file2 = new Path(sub1, "sub1file2");
        DFSTestUtil.createFile((FileSystem)this.hdfs, sub1file1, 1024L, (short)1, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, sub1file2, 1024L, (short)1, 0L);
        this.checkImage(s);
        this.hdfs.createSnapshot(this.dir, "s" + ++s);
        Path sub2 = new Path(this.dir, "sub2");
        Path sub2file1 = new Path(sub2, "sub2file1");
        Path sub2file2 = new Path(sub2, "sub2file2");
        DFSTestUtil.createFile((FileSystem)this.hdfs, sub2file1, 1024L, (short)1, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, sub2file2, 1024L, (short)1, 0L);
        this.checkImage(s);
        this.hdfs.createSnapshot(this.dir, "s" + ++s);
        this.hdfs.setReplication(sub1file1, (short)1);
        this.hdfs.delete(sub1file2, true);
        this.hdfs.setOwner(sub2, "dr.who", "unknown");
        this.hdfs.delete(sub2file1, true);
        this.checkImage(s);
        this.hdfs.createSnapshot(this.dir, "s" + ++s);
        Path sub1_sub2file2 = new Path(sub1, "sub2file2");
        this.hdfs.rename(sub2file2, sub1_sub2file2);
        this.hdfs.rename(sub1file1, sub2file1);
        this.checkImage(s);
        this.hdfs.rename(sub2file1, sub2file2);
        this.checkImage(s);
    }

    void checkImage(int s) throws IOException {
        String name = "s" + s;
        File fsnBefore = this.dumpTree2File(name + "_before");
        File imageFile = this.saveFSImageToTempFile();
        long numSdirBefore = this.fsn.getNumSnapshottableDirs();
        long numSnapshotBefore = this.fsn.getNumSnapshots();
        SnapshottableDirectoryStatus[] dirBefore = this.hdfs.getSnapshottableDirListing();
        this.cluster.shutdown();
        File fsnBetween = this.dumpTree2File(name + "_between");
        SnapshotTestHelper.compareDumpedTreeInFile(fsnBefore, fsnBetween, true);
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(true).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        this.loadFSImageFromTempFile(imageFile);
        File fsnAfter = this.dumpTree2File(name + "_after");
        SnapshotTestHelper.compareDumpedTreeInFile(fsnBefore, fsnAfter, true);
        long numSdirAfter = this.fsn.getNumSnapshottableDirs();
        long numSnapshotAfter = this.fsn.getNumSnapshots();
        SnapshottableDirectoryStatus[] dirAfter = this.hdfs.getSnapshottableDirListing();
        Assert.assertEquals((long)numSdirBefore, (long)numSdirAfter);
        Assert.assertEquals((long)numSnapshotBefore, (long)numSnapshotAfter);
        Assert.assertEquals((long)dirBefore.length, (long)dirAfter.length);
        ArrayList<String> pathListBefore = new ArrayList<String>();
        for (SnapshottableDirectoryStatus sBefore : dirBefore) {
            pathListBefore.add(sBefore.getFullPath().toString());
        }
        for (SnapshottableDirectoryStatus sAfter : dirAfter) {
            Assert.assertTrue((boolean)pathListBefore.contains(sAfter.getFullPath().toString()));
        }
    }

    @Test(timeout=60000L)
    public void testSaveLoadImageWithAppending() throws Exception {
        Path sub1 = new Path(this.dir, "sub1");
        Path sub1file1 = new Path(sub1, "sub1file1");
        Path sub1file2 = new Path(sub1, "sub1file2");
        DFSTestUtil.createFile((FileSystem)this.hdfs, sub1file1, 1024L, (short)1, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, sub1file2, 1024L, (short)1, 0L);
        this.hdfs.allowSnapshot(this.dir);
        this.hdfs.createSnapshot(this.dir, "s0");
        HdfsDataOutputStream out = this.appendFileWithoutClosing(sub1file1, 1024);
        out.hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        DFSTestUtil.appendFile((FileSystem)this.hdfs, sub1file2, 1024);
        this.hdfs.createSnapshot(this.dir, "s1");
        out.close();
        out = this.appendFileWithoutClosing(sub1file1, 1024);
        out.hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        this.hdfs.createSnapshot(this.dir, "s2");
        out.close();
        out = this.appendFileWithoutClosing(sub1file1, 1024);
        out.hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        File fsnBefore = this.dumpTree2File("before");
        File imageFile = this.saveFSImageToTempFile();
        out.close();
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(true).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        this.loadFSImageFromTempFile(imageFile);
        File fsnAfter = this.dumpTree2File("after");
        SnapshotTestHelper.compareDumpedTreeInFile(fsnBefore, fsnAfter, true);
    }

    @Test(timeout=60000L)
    public void testLoadImageWithAppending() throws Exception {
        Path sub1 = new Path(this.dir, "sub1");
        Path sub1file1 = new Path(sub1, "sub1file1");
        Path sub1file2 = new Path(sub1, "sub1file2");
        DFSTestUtil.createFile((FileSystem)this.hdfs, sub1file1, 1024L, (short)1, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, sub1file2, 1024L, (short)1, 0L);
        this.hdfs.allowSnapshot(this.dir);
        this.hdfs.createSnapshot(this.dir, "s0");
        HdfsDataOutputStream out = this.appendFileWithoutClosing(sub1file1, 1024);
        out.hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        this.hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
    }

    @Test(timeout=60000L)
    public void testLoadImageWithEmptyFile() throws Exception {
        Path file = new Path(this.dir, "file");
        FSDataOutputStream out = this.hdfs.create(file);
        out.close();
        this.hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        out = this.hdfs.append(file);
        out.write(1);
        out.close();
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.hdfs = this.cluster.getFileSystem();
        FileStatus status = this.hdfs.getFileStatus(file);
        Assert.assertEquals((long)1L, (long)status.getLen());
    }

    @Test(timeout=300000L)
    public void testSaveLoadImageAfterSnapshotDeletion() throws Exception {
        Path dir = new Path("/dir");
        Path subDir = new Path(dir, "subdir");
        Path subsubDir = new Path(subDir, "subsubdir");
        this.hdfs.mkdirs(subsubDir);
        SnapshotTestHelper.createSnapshot(this.hdfs, dir, "s1");
        Path newDir = new Path(subsubDir, "newdir");
        Path newFile = new Path(newDir, "newfile");
        this.hdfs.mkdirs(newDir);
        DFSTestUtil.createFile((FileSystem)this.hdfs, newFile, 1024L, (short)1, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, dir, "s2");
        this.hdfs.delete(subsubDir, true);
        this.hdfs.deleteSnapshot(dir, "s2");
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).format(false).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        this.hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
    }

    void rename(Path src, Path dst) throws Exception {
        this.printTree("Before rename " + src + " -> " + dst);
        this.hdfs.rename(src, dst);
        this.printTree("After rename " + src + " -> " + dst);
    }

    void createFile(Path directory, String filename) throws Exception {
        Path f = new Path(directory, filename);
        DFSTestUtil.createFile((FileSystem)this.hdfs, f, 0L, (short)1, 0L);
    }

    void appendFile(Path directory, String filename) throws Exception {
        Path f = new Path(directory, filename);
        DFSTestUtil.appendFile((FileSystem)this.hdfs, f, "more data");
        this.printTree("appended " + f);
    }

    void deleteSnapshot(Path directory, String snapshotName) throws Exception {
        this.hdfs.deleteSnapshot(directory, snapshotName);
        this.printTree("deleted snapshot " + snapshotName);
    }

    @Test(timeout=60000L)
    public void testDoubleRename() throws Exception {
        Path parent = new Path("/parent");
        this.hdfs.mkdirs(parent);
        Path sub1 = new Path(parent, "sub1");
        Path sub1foo = new Path(sub1, "foo");
        this.hdfs.mkdirs(sub1);
        this.hdfs.mkdirs(sub1foo);
        this.createFile(sub1foo, "file0");
        this.printTree("before s0");
        this.hdfs.allowSnapshot(parent);
        this.hdfs.createSnapshot(parent, "s0");
        this.createFile(sub1foo, "file1");
        this.createFile(sub1foo, "file2");
        Path sub2 = new Path(parent, "sub2");
        this.hdfs.mkdirs(sub2);
        Path sub2foo = new Path(sub2, "foo");
        this.rename(sub1foo, sub2foo);
        this.hdfs.createSnapshot(parent, "s1");
        this.hdfs.createSnapshot(parent, "s2");
        this.printTree("created snapshots: s1, s2");
        this.appendFile(sub2foo, "file1");
        this.createFile(sub2foo, "file3");
        Path sub3 = new Path(parent, "sub3");
        this.hdfs.mkdirs(sub3);
        this.rename(sub2foo, sub3);
        this.hdfs.delete(sub3, true);
        this.printTree("deleted " + sub3);
        this.deleteSnapshot(parent, "s1");
        this.restartCluster();
        this.deleteSnapshot(parent, "s2");
        this.restartCluster();
    }

    void restartCluster() throws Exception {
        File before = this.dumpTree2File("before.txt");
        this.hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        this.hdfs.saveNamespace();
        this.hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        this.cluster.shutdown();
        this.cluster = new MiniDFSCluster.Builder(this.conf).format(false).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.hdfs = this.cluster.getFileSystem();
        File after = this.dumpTree2File("after.txt");
        SnapshotTestHelper.compareDumpedTreeInFile(before, after, true);
    }

    String printTree(String label) throws Exception {
        this.output.println();
        this.output.println();
        this.output.println("***** " + this.printTreeCount++ + ": " + label);
        String b = this.fsn.getFSDirectory().getINode("/").dumpTreeRecursively().toString();
        this.output.println(b);
        return b;
    }
}

