/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.CombinedHostFileManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNameNodeMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(TestNameNodeMXBean.class);
    private static final double DELTA = 1.0E-6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameNodeMXBeanInfo() throws Exception {
        Configuration conf = new Configuration();
        Long maxLockedMemory = Shell.getMemlockLimit((Long)NativeIO.POSIX.getCacheManipulator().getMemlockLimit());
        conf.setLong("dfs.datanode.max.locked.memory", maxLockedMemory.longValue());
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            cluster.waitActive();
            String upgradeDomain = "abcd";
            DatanodeManager dm = cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager();
            DatanodeDescriptor dd = dm.getDatanode(cluster.getDataNodes().get(0).getDatanodeId());
            dd.setUpgradeDomain(upgradeDomain);
            String dnXferAddrWithUpgradeDomainSet = dd.getXferAddr();
            DatanodeDescriptor maintenanceNode = dm.getDatanode(cluster.getDataNodes().get(1).getDatanodeId());
            maintenanceNode.setInMaintenance();
            String dnXferAddrInMaintenance = maintenanceNode.getXferAddr();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            String clusterId = (String)mbs.getAttribute(mxbeanName, "ClusterId");
            Assert.assertEquals((Object)fsn.getClusterId(), (Object)clusterId);
            String blockpoolId = (String)mbs.getAttribute(mxbeanName, "BlockPoolId");
            Assert.assertEquals((Object)fsn.getBlockPoolId(), (Object)blockpoolId);
            String version = (String)mbs.getAttribute(mxbeanName, "Version");
            Assert.assertEquals((Object)fsn.getVersion(), (Object)version);
            Assert.assertTrue((boolean)version.equals(VersionInfo.getVersion() + ", r" + VersionInfo.getRevision()));
            Long used = (Long)mbs.getAttribute(mxbeanName, "Used");
            Assert.assertEquals((long)fsn.getUsed(), (long)used);
            Long total = (Long)mbs.getAttribute(mxbeanName, "Total");
            Assert.assertEquals((long)fsn.getTotal(), (long)total);
            String safemode = (String)mbs.getAttribute(mxbeanName, "Safemode");
            Assert.assertEquals((Object)fsn.getSafemode(), (Object)safemode);
            Long nondfs = (Long)mbs.getAttribute(mxbeanName, "NonDfsUsedSpace");
            Assert.assertEquals((long)fsn.getNonDfsUsedSpace(), (long)nondfs);
            Float percentremaining = (Float)mbs.getAttribute(mxbeanName, "PercentRemaining");
            Assert.assertEquals((double)fsn.getPercentRemaining(), (double)percentremaining.floatValue(), (double)1.0E-6);
            Long totalblocks = (Long)mbs.getAttribute(mxbeanName, "TotalBlocks");
            Assert.assertEquals((long)fsn.getTotalBlocks(), (long)totalblocks);
            String alivenodeinfo = (String)mbs.getAttribute(mxbeanName, "LiveNodes");
            Map liveNodes = (Map)JSON.parse((String)alivenodeinfo);
            Assert.assertTrue((liveNodes.size() == 2 ? 1 : 0) != 0);
            for (Map liveNode : liveNodes.values()) {
                Assert.assertTrue((boolean)liveNode.containsKey("nonDfsUsedSpace"));
                Assert.assertTrue(((Long)liveNode.get("nonDfsUsedSpace") >= 0L ? 1 : 0) != 0);
                Assert.assertTrue((boolean)liveNode.containsKey("capacity"));
                Assert.assertTrue(((Long)liveNode.get("capacity") > 0L ? 1 : 0) != 0);
                Assert.assertTrue((boolean)liveNode.containsKey("numBlocks"));
                Assert.assertTrue(((Long)liveNode.get("numBlocks") == 0L ? 1 : 0) != 0);
                Assert.assertTrue((boolean)liveNode.containsKey("lastBlockReport"));
                String xferAddr = (String)liveNode.get("xferaddr");
                if (!xferAddr.equals(dnXferAddrWithUpgradeDomainSet)) {
                    Assert.assertTrue((!liveNode.containsKey("upgradeDomain") ? 1 : 0) != 0);
                } else {
                    Assert.assertTrue((boolean)liveNode.get("upgradeDomain").equals(upgradeDomain));
                }
                boolean inMaintenance = liveNode.get("adminState").equals(DatanodeInfo.AdminStates.IN_MAINTENANCE.toString());
                Assert.assertFalse((boolean)(xferAddr.equals(dnXferAddrInMaintenance) ^ inMaintenance));
            }
            Assert.assertEquals((Object)fsn.getLiveNodes(), (Object)alivenodeinfo);
            String deadNodeInfo = (String)mbs.getAttribute(mxbeanName, "DeadNodes");
            Assert.assertEquals((Object)fsn.getDeadNodes(), (Object)deadNodeInfo);
            String nodeUsage = (String)mbs.getAttribute(mxbeanName, "NodeUsage");
            Assert.assertEquals((String)"Bad value for NodeUsage", (Object)fsn.getNodeUsage(), (Object)nodeUsage);
            String nameJournalStatus = (String)mbs.getAttribute(mxbeanName, "NameJournalStatus");
            Assert.assertEquals((String)"Bad value for NameJournalStatus", (Object)fsn.getNameJournalStatus(), (Object)nameJournalStatus);
            String journalTxnInfo = (String)mbs.getAttribute(mxbeanName, "JournalTransactionInfo");
            Assert.assertEquals((String)"Bad value for NameTxnIds", (Object)fsn.getJournalTransactionInfo(), (Object)journalTxnInfo);
            String compileInfo = (String)mbs.getAttribute(mxbeanName, "CompileInfo");
            Assert.assertEquals((String)"Bad value for CompileInfo", (Object)fsn.getCompileInfo(), (Object)compileInfo);
            String corruptFiles = (String)mbs.getAttribute(mxbeanName, "CorruptFiles");
            Assert.assertEquals((String)"Bad value for CorruptFiles", (Object)fsn.getCorruptFiles(), (Object)corruptFiles);
            String nameDirStatuses = (String)mbs.getAttribute(mxbeanName, "NameDirStatuses");
            Assert.assertEquals((Object)fsn.getNameDirStatuses(), (Object)nameDirStatuses);
            Map statusMap = (Map)JSON.parse((String)nameDirStatuses);
            Collection<URI> nameDirUris = cluster.getNameDirs(0);
            for (URI nameDirUri : nameDirUris) {
                File nameDir = new File(nameDirUri);
                System.out.println("Checking for the presence of " + nameDir + " in active name dirs.");
                Assert.assertTrue((boolean)((Map)statusMap.get("active")).containsKey(nameDir.getAbsolutePath()));
            }
            Assert.assertEquals((long)2L, (long)((Map)statusMap.get("active")).size());
            Assert.assertEquals((long)0L, (long)((Map)statusMap.get("failed")).size());
            File failedNameDir = new File(nameDirUris.iterator().next());
            Assert.assertEquals((long)0L, (long)FileUtil.chmod((String)new File(failedNameDir, "current").getAbsolutePath(), (String)"000"));
            cluster.getNameNodeRpc().rollEditLog();
            nameDirStatuses = (String)mbs.getAttribute(mxbeanName, "NameDirStatuses");
            statusMap = (Map)JSON.parse((String)nameDirStatuses);
            for (URI nameDirUri : nameDirUris) {
                File nameDir = new File(nameDirUri);
                String expectedStatus = nameDir.equals(failedNameDir) ? "failed" : "active";
                System.out.println("Checking for the presence of " + nameDir + " in " + expectedStatus + " name dirs.");
                Assert.assertTrue((boolean)((Map)statusMap.get(expectedStatus)).containsKey(nameDir.getAbsolutePath()));
            }
            Assert.assertEquals((long)1L, (long)((Map)statusMap.get("active")).size());
            Assert.assertEquals((long)1L, (long)((Map)statusMap.get("failed")).size());
            Assert.assertEquals((Object)0L, (Object)mbs.getAttribute(mxbeanName, "CacheUsed"));
            Assert.assertEquals((Object)(maxLockedMemory * (long)cluster.getDataNodes().size()), (Object)mbs.getAttribute(mxbeanName, "CacheCapacity"));
            Assert.assertNull((String)"RollingUpgradeInfo should be null when there is no rolling upgrade", (Object)mbs.getAttribute(mxbeanName, "RollingUpgradeStatus"));
        }
        finally {
            if (cluster != null) {
                for (URI dir : cluster.getNameDirs(0)) {
                    FileUtil.chmod((String)new File(new File(dir), "current").getAbsolutePath(), (String)"755");
                }
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastContactTime() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1);
        MiniDFSCluster cluster = null;
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(conf, "temp/TestNameNodeMXBean");
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            ArrayList<String> hosts = new ArrayList<String>();
            for (DataNode dn : cluster.getDataNodes()) {
                hosts.add(dn.getDisplayName());
            }
            hostsFileWriter.initIncludeHosts(hosts.toArray(new String[hosts.size()]));
            fsn.getBlockManager().getDatanodeManager().refreshNodes(conf);
            cluster.stopDataNode(0);
            while (fsn.getBlockManager().getDatanodeManager().getNumLiveDataNodes() != 2) {
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            String deadNodeInfo = (String)mbs.getAttribute(mxbeanName, "DeadNodes");
            Assert.assertEquals((Object)fsn.getDeadNodes(), (Object)deadNodeInfo);
            Map deadNodes = (Map)JSON.parse((String)deadNodeInfo);
            Assert.assertTrue((deadNodes.size() > 0 ? 1 : 0) != 0);
            for (Map deadNode : deadNodes.values()) {
                Assert.assertTrue((boolean)deadNode.containsKey("lastContact"));
                Assert.assertTrue((boolean)deadNode.containsKey("adminState"));
                Assert.assertTrue((boolean)deadNode.containsKey("xferaddr"));
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            hostsFileWriter.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testDecommissioningNodes() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 30);
        MiniDFSCluster cluster = null;
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(conf, "temp/TestNameNodeMXBean");
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            cluster.waitActive();
            final FSNamesystem fsn = cluster.getNameNode().namesystem;
            final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            final ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            ArrayList<String> hosts = new ArrayList<String>();
            for (DataNode dn : cluster.getDataNodes()) {
                hosts.add(dn.getDisplayName());
            }
            hostsFileWriter.initIncludeHosts(hosts.toArray(new String[hosts.size()]));
            fsn.getBlockManager().getDatanodeManager().refreshNodes(conf);
            String liveNodesInfo = (String)mbs.getAttribute(mxbeanName, "LiveNodes");
            Map liveNodes = (Map)JSON.parse((String)liveNodesInfo);
            Assert.assertEquals((Object)fsn.getLiveNodes(), (Object)liveNodesInfo);
            Assert.assertEquals((long)fsn.getNumLiveDataNodes(), (long)liveNodes.size());
            for (Map liveNode : liveNodes.values()) {
                Assert.assertTrue((boolean)liveNode.containsKey("lastContact"));
                Assert.assertTrue((boolean)liveNode.containsKey("xferaddr"));
            }
            hostsFileWriter.initExcludeHost(cluster.getDataNodes().get(0).getDisplayName());
            fsn.getBlockManager().getDatanodeManager().refreshNodes(conf);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    try {
                        String decomNodesInfo = (String)mbs.getAttribute(mxbeanName, "DecomNodes");
                        Map decomNodes = (Map)JSON.parse((String)decomNodesInfo);
                        if (decomNodes.size() > 0) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return false;
                }
            }, (int)1000, (int)60000);
            String decomNodesInfo = (String)mbs.getAttribute(mxbeanName, "DecomNodes");
            Map decomNodes = (Map)JSON.parse((String)decomNodesInfo);
            Assert.assertEquals((Object)fsn.getDecomNodes(), (Object)decomNodesInfo);
            Assert.assertEquals((long)fsn.getNumDecommissioningDataNodes(), (long)decomNodes.size());
            Assert.assertEquals((long)0L, (long)fsn.getNumDecomLiveDataNodes());
            Assert.assertEquals((long)0L, (long)fsn.getNumDecomDeadDataNodes());
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    if (fsn.getNumDecomLiveDataNodes() == 1) {
                        return true;
                    }
                    return false;
                }
            }, (int)1000, (int)60000);
            decomNodesInfo = (String)mbs.getAttribute(mxbeanName, "DecomNodes");
            decomNodes = (Map)JSON.parse((String)decomNodesInfo);
            Assert.assertEquals((long)0L, (long)decomNodes.size());
            Assert.assertEquals((Object)fsn.getDecomNodes(), (Object)decomNodesInfo);
            Assert.assertEquals((long)1L, (long)fsn.getNumDecomLiveDataNodes());
            Assert.assertEquals((long)0L, (long)fsn.getNumDecomDeadDataNodes());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            hostsFileWriter.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testMaintenanceNodes() throws Exception {
        LOG.info("Starting testMaintenanceNodes");
        int expirationInMs = 30000;
        Configuration conf = new Configuration();
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", expirationInMs);
        conf.setClass("dfs.namenode.hosts.provider.classname", CombinedHostFileManager.class, HostConfigManager.class);
        MiniDFSCluster cluster = null;
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(conf, "temp/TestNameNodeMXBean");
        try {
            Map enteringMaintenanceNodes;
            String enteringMaintenanceNodesInfo;
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            ArrayList<String> hosts = new ArrayList<String>();
            for (DataNode dn : cluster.getDataNodes()) {
                hosts.add(dn.getDisplayName());
            }
            hostsFileWriter.initIncludeHosts(hosts.toArray(new String[hosts.size()]));
            fsn.getBlockManager().getDatanodeManager().refreshNodes(conf);
            String liveNodesInfo = (String)mbs.getAttribute(mxbeanName, "LiveNodes");
            LOG.info("Live Nodes: " + liveNodesInfo);
            Map liveNodes = (Map)JSON.parse((String)liveNodesInfo);
            Assert.assertEquals((Object)fsn.getLiveNodes(), (Object)liveNodesInfo);
            Assert.assertEquals((long)fsn.getNumLiveDataNodes(), (long)liveNodes.size());
            for (Map liveNode : liveNodes.values()) {
                Assert.assertTrue((boolean)liveNode.containsKey("lastContact"));
                Assert.assertTrue((boolean)liveNode.containsKey("xferaddr"));
            }
            HashMap<String, Long> maintenanceNodes = new HashMap<String, Long>();
            maintenanceNodes.put(cluster.getDataNodes().get(0).getDisplayName(), Time.now() + (long)expirationInMs);
            hostsFileWriter.initOutOfServiceHosts(null, maintenanceNodes);
            fsn.getBlockManager().getDatanodeManager().refreshNodes(conf);
            boolean recheck = true;
            while (recheck) {
                enteringMaintenanceNodesInfo = (String)mbs.getAttribute(mxbeanName, "EnteringMaintenanceNodes");
                enteringMaintenanceNodes = (Map)JSON.parse((String)enteringMaintenanceNodesInfo);
                if (enteringMaintenanceNodes.size() <= 0) {
                    LOG.info("Waiting for a node to Enter Maintenance state!");
                    Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    continue;
                }
                LOG.info("Nodes entering Maintenance: " + enteringMaintenanceNodesInfo);
                recheck = false;
                Assert.assertEquals((Object)fsn.getEnteringMaintenanceNodes(), (Object)enteringMaintenanceNodesInfo);
                Assert.assertEquals((long)fsn.getNumEnteringMaintenanceDataNodes(), (long)enteringMaintenanceNodes.size());
                Assert.assertEquals((long)0L, (long)fsn.getNumInMaintenanceLiveDataNodes());
                Assert.assertEquals((long)0L, (long)fsn.getNumInMaintenanceDeadDataNodes());
            }
            while (fsn.getNumInMaintenanceLiveDataNodes() != 1) {
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            enteringMaintenanceNodesInfo = (String)mbs.getAttribute(mxbeanName, "EnteringMaintenanceNodes");
            enteringMaintenanceNodes = (Map)JSON.parse((String)enteringMaintenanceNodesInfo);
            Assert.assertEquals((long)0L, (long)enteringMaintenanceNodes.size());
            Assert.assertEquals((Object)fsn.getEnteringMaintenanceNodes(), (Object)enteringMaintenanceNodesInfo);
            Assert.assertEquals((long)1L, (long)fsn.getNumInMaintenanceLiveDataNodes());
            Assert.assertEquals((long)0L, (long)fsn.getNumInMaintenanceDeadDataNodes());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            hostsFileWriter.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testTopUsers() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanNameFsns = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/");
            int NUM_OPS = 10;
            for (int i = 0; i < 10; ++i) {
                fs.listStatus(path);
                fs.setTimes(path, 0L, 1L);
            }
            String topUsers = (String)mbs.getAttribute(mxbeanNameFsns, "TopUserOpCounts");
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(topUsers, Map.class);
            Assert.assertTrue((String)"Could not find map key timestamp", (boolean)map.containsKey("timestamp"));
            Assert.assertTrue((String)"Could not find map key windows", (boolean)map.containsKey("windows"));
            List windows = (List)map.get("windows");
            Assert.assertEquals((String)"Unexpected num windows", (long)3L, (long)windows.size());
            for (Map window : windows) {
                List ops = (List)window.get("ops");
                Assert.assertEquals((String)"Unexpected num ops", (long)3L, (long)ops.size());
                for (Map op : ops) {
                    long count = Long.parseLong(op.get("totalCount").toString());
                    String opType = op.get("opType").toString();
                    int expected = opType.equals("*") ? 20 : 10;
                    Assert.assertEquals((String)"Unexpected total count", (long)expected, (long)count);
                }
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testTopUsersDisabled() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.top.enabled", false);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanNameFsns = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/");
            int NUM_OPS = 10;
            for (int i = 0; i < 10; ++i) {
                fs.listStatus(path);
                fs.setTimes(path, 0L, 1L);
            }
            String topUsers = (String)mbs.getAttribute(mxbeanNameFsns, "TopUserOpCounts");
            Assert.assertNull((String)"Did not expect to find TopUserOpCounts bean!", (Object)topUsers);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testTopUsersNoPeriods() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.top.enabled", true);
        conf.set("dfs.namenode.top.windows.minutes", "");
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanNameFsns = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/");
            int NUM_OPS = 10;
            for (int i = 0; i < 10; ++i) {
                fs.listStatus(path);
                fs.setTimes(path, 0L, 1L);
            }
            String topUsers = (String)mbs.getAttribute(mxbeanNameFsns, "TopUserOpCounts");
            Assert.assertNotNull((String)"Expected TopUserOpCounts bean!", (Object)topUsers);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testQueueLength() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanNameFs = new ObjectName("Hadoop:service=NameNode,name=FSNamesystem");
            int queueLength = (Integer)mbs.getAttribute(mxbeanNameFs, "LockQueueLength");
            Assert.assertEquals((long)0L, (long)queueLength);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testNNDirectorySize() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.ha.log-roll.period", 0);
        MiniDFSCluster cluster = null;
        for (int i = 0; i < 5; ++i) {
            try {
                int[] ports = ServerSocketUtil.getPorts((int)2);
                MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf("nn1").setIpcPort(ports[0])).addNN(new MiniDFSNNTopology.NNConf("nn2").setIpcPort(ports[1])));
                cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).numDataNodes(0).build();
                break;
            }
            catch (BindException e) {
                continue;
            }
        }
        if (cluster == null) {
            Assert.fail((String)"failed to start mini cluster.");
        }
        DistributedFileSystem fs = null;
        try {
            cluster.waitActive();
            FSNamesystem nn0 = cluster.getNamesystem(0);
            FSNamesystem nn1 = cluster.getNamesystem(1);
            cluster.transitionToActive(0);
            fs = cluster.getFileSystem(0);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/file"), 0L, (short)1, 0L);
            HATestUtil.waitForStandbyToCatchUp(cluster.getNameNode(0), cluster.getNameNode(1));
            this.checkNNDirSize(cluster.getNameDirs(0), nn0.getNameDirSize());
            this.checkNNDirSize(cluster.getNameDirs(1), nn1.getNameDirSize());
            DFSTestUtil.createFile((FileSystem)fs, new Path("/file"), 0L, (short)1, 0L);
            nn0.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            nn0.saveNamespace();
            this.checkNNDirSize(cluster.getNameDirs(0), nn0.getNameDirSize());
        }
        finally {
            cluster.shutdown();
        }
    }

    private void checkNNDirSize(Collection<URI> nameDirUris, String metric) {
        Map nnDirMap = (Map)JSON.parse((String)metric);
        Assert.assertEquals((long)nameDirUris.size(), (long)nnDirMap.size());
        for (URI dirUrl : nameDirUris) {
            File dir = new File(dirUrl);
            Assert.assertEquals((long)((Long)nnDirMap.get(dir.getAbsolutePath())), (long)FileUtils.sizeOfDirectory((File)dir));
        }
    }

    static {
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)new NativeIO.POSIX.NoMlockCacheManipulator());
    }
}

