/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.FSImageCompression;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.io.compress.CompressionCodec;

@InterfaceAudience.Private
public final class FSImageUtil {
    public static final byte[] MAGIC_HEADER = "HDFSIMG1".getBytes(StandardCharsets.UTF_8);
    public static final int FILE_VERSION = 1;

    public static boolean checkFileFormat(RandomAccessFile file) throws IOException {
        if (file.length() < 8L) {
            return false;
        }
        byte[] magic = new byte[MAGIC_HEADER.length];
        file.readFully(magic);
        return Arrays.equals(MAGIC_HEADER, magic);
    }

    public static FsImageProto.FileSummary loadSummary(RandomAccessFile file) throws IOException {
        int FILE_LENGTH_FIELD_SIZE = 4;
        long fileLength = file.length();
        file.seek(fileLength - 4L);
        int summaryLength = file.readInt();
        if (summaryLength <= 0) {
            throw new IOException("Negative length of the file");
        }
        file.seek(fileLength - 4L - (long)summaryLength);
        byte[] summaryBytes = new byte[summaryLength];
        file.readFully(summaryBytes);
        FsImageProto.FileSummary summary = FsImageProto.FileSummary.parseDelimitedFrom(new ByteArrayInputStream(summaryBytes));
        if (summary.getOndiskVersion() != 1) {
            throw new IOException("Unsupported file version " + summary.getOndiskVersion());
        }
        if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.PROTOBUF_FORMAT, summary.getLayoutVersion())) {
            throw new IOException("Unsupported layout version " + summary.getLayoutVersion());
        }
        return summary;
    }

    public static InputStream wrapInputStreamForCompression(Configuration conf, String codec, InputStream in) throws IOException {
        if (codec.isEmpty()) {
            return in;
        }
        FSImageCompression compression = FSImageCompression.createCompression(conf, codec);
        CompressionCodec imageCodec = compression.getImageCodec();
        return imageCodec.createInputStream(in);
    }
}

