/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppView;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class TaskPage
extends AppView {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:3}");
        this.set("ui.dataTables.id", "attempts");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"attempts"), this.attemptsTableInit());
        this.setTableStyles(html, "attempts", new String[0]);
    }

    @Override
    protected Class<? extends SubView> content() {
        return AttemptsBlock.class;
    }

    private String attemptsTableInit() {
        return JQueryUI.tableInit().append(", 'aaData': attemptsTableData").append(", bDeferRender: true").append(", bProcessing: true").append("\n,aoColumnDefs:[\n").append("\n{'aTargets': [ 5 ]").append(", 'bSearchable': false }").append("\n, {'sType':'numeric', 'aTargets': [ 6, 7").append(" ], 'mRender': renderHadoopDate }").append("\n, {'sType':'numeric', 'aTargets': [ 8").append(" ], 'mRender': renderHadoopElapsedTime }]").append("\n, aaSorting: [[0, 'asc']]").append("}").toString();
    }

    static class AttemptsBlock
    extends HtmlBlock {
        final App app;

        @Inject
        AttemptsBlock(App ctx) {
            this.app = ctx;
        }

        protected void render(HtmlBlock.Block html) {
            if (!this.isValidRequest()) {
                html.h2(this.$("title"));
                return;
            }
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#attempts").thead().tr().th(".id", "Attempt").th(".progress", "Progress").th(".state", "State").th(".status", "Status").th(".node", "Node").th(".logs", "Logs").th(".tsh", "Started").th(".tsh", "Finished").th(".tsh", "Elapsed").th(".note", "Note")._())._()).tbody();
            StringBuilder attemptsTableData = new StringBuilder("[\n");
            for (TaskAttempt attempt : this.getTaskAttempts()) {
                TaskAttemptInfo ta = new TaskAttemptInfo(attempt, true);
                String progress = StringHelper.percent((double)(ta.getProgress() / 100.0f));
                String nodeHttpAddr = ta.getNode();
                String diag = ta.getNote() == null ? "" : ta.getNote();
                attemptsTableData.append("[\"").append(ta.getId()).append("\",\"").append(progress).append("\",\"").append(ta.getState().toString()).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)ta.getStatus()))).append("\",\"").append(nodeHttpAddr == null ? "N/A" : "<a class='nodelink' href='" + MRWebAppUtil.getYARNWebappScheme() + nodeHttpAddr + "'>" + nodeHttpAddr + "</a>").append("\",\"").append(ta.getAssignedContainerId() == null ? "N/A" : "<a class='logslink' href='" + this.url(new String[]{MRWebAppUtil.getYARNWebappScheme(), nodeHttpAddr, "node", "containerlogs", ta.getAssignedContainerIdStr(), this.app.getJob().getUserName()}) + "'>logs</a>").append("\",\"").append(ta.getStartTime()).append("\",\"").append(ta.getFinishTime()).append("\",\"").append(ta.getElapsedTime()).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)diag))).append("\"],\n");
            }
            if (attemptsTableData.charAt(attemptsTableData.length() - 2) == ',') {
                attemptsTableData.delete(attemptsTableData.length() - 2, attemptsTableData.length() - 1);
            }
            attemptsTableData.append("]");
            html.script().$type("text/javascript")._(new Object[]{"var attemptsTableData=" + attemptsTableData})._();
            ((Hamlet.TABLE)tbody._())._();
        }

        protected boolean isValidRequest() {
            return this.app.getTask() != null;
        }

        protected Collection<TaskAttempt> getTaskAttempts() {
            return this.app.getTask().getAttempts().values();
        }
    }
}

