/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.JobID;

class JobInfo
implements Writable {
    private JobID id;
    private Text user;
    private Path jobSubmitDir;

    public JobInfo() {
    }

    public JobInfo(JobID id, Text user, Path jobSubmitDir) {
        this.id = id;
        this.user = user;
        this.jobSubmitDir = jobSubmitDir;
    }

    public JobID getJobID() {
        return this.id;
    }

    public Text getUser() {
        return this.user;
    }

    public Path getJobSubmitDir() {
        return this.jobSubmitDir;
    }

    public void readFields(DataInput in) throws IOException {
        this.id = new JobID();
        this.id.readFields(in);
        this.user = new Text();
        this.user.readFields(in);
        this.jobSubmitDir = new Path(WritableUtils.readString((DataInput)in));
    }

    public void write(DataOutput out) throws IOException {
        this.id.write(out);
        this.user.write(out);
        WritableUtils.writeString((DataOutput)out, (String)this.jobSubmitDir.toString());
    }
}

