/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.junit.Assert;
import org.junit.Test;

public class TestClusterMapReduceTestCase
extends ClusterMapReduceTestCase {
    public void _testMapReduce(boolean restart) throws Exception {
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getInputDir(), "text.txt"));
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("hello1\n");
        wr.write("hello2\n");
        wr.write("hello3\n");
        wr.write("hello4\n");
        ((Writer)wr).close();
        if (restart) {
            this.stopCluster();
            this.startCluster(false, null);
        }
        JobConf conf = this.createJobConf();
        conf.setJobName("mr");
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.getInputDir()});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)this.getOutputDir());
        JobClient.runJob((JobConf)conf);
        Path[] outputFiles = FileUtil.stat2Paths((FileStatus[])this.getFileSystem().listStatus(this.getOutputDir(), (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
        if (outputFiles.length > 0) {
            FSDataInputStream is = this.getFileSystem().open(outputFiles[0]);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            String line = reader.readLine();
            int counter = 0;
            while (line != null) {
                ++counter;
                Assert.assertTrue((boolean)line.contains("hello"));
                line = reader.readLine();
            }
            reader.close();
            Assert.assertEquals((long)4L, (long)counter);
        }
    }

    @Test
    public void testMapReduce() throws Exception {
        this._testMapReduce(false);
    }

    @Test
    public void testMapReduceRestarting() throws Exception {
        this._testMapReduce(true);
    }

    @Test
    public void testDFSRestart() throws Exception {
        Path file = new Path(this.getInputDir(), "text.txt");
        FSDataOutputStream os = this.getFileSystem().create(file);
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        ((Writer)wr).close();
        this.stopCluster();
        this.startCluster(false, null);
        Assert.assertTrue((boolean)this.getFileSystem().exists(file));
        this.stopCluster();
        this.startCluster(true, null);
        Assert.assertFalse((boolean)this.getFileSystem().exists(file));
    }

    @Test
    public void testMRConfig() throws Exception {
        JobConf conf = this.createJobConf();
        Assert.assertNull((Object)conf.get("xyz"));
        Properties config = new Properties();
        config.setProperty("xyz", "XYZ");
        this.stopCluster();
        this.startCluster(false, config);
        conf = this.createJobConf();
        Assert.assertEquals((Object)"XYZ", (Object)conf.get("xyz"));
    }
}

