/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KeyValueLineRecordReader;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestKeyValueTextInputFormat {
    private static final Log LOG = LogFactory.getLog((String)TestKeyValueTextInputFormat.class.getName());
    private static int MAX_LENGTH = 10000;
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    private static Path workDir;
    private static final Reporter voidReporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFormat() throws Exception {
        JobConf job = new JobConf();
        Path file = new Path(workDir, "test.txt");
        Reporter reporter = Reporter.NULL;
        int seed = new Random().nextInt();
        LOG.info((Object)("seed = " + seed));
        Random random = new Random(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        for (int length = 0; length < MAX_LENGTH; length += random.nextInt(MAX_LENGTH / 10) + 1) {
            LOG.debug((Object)("creating; entries = " + length));
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));){
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i * 2));
                    writer.write("\t");
                    writer.write(Integer.toString(i));
                    writer.write("\n");
                }
            }
            KeyValueTextInputFormat format = new KeyValueTextInputFormat();
            format.configure(job);
            for (int i = 0; i < 3; ++i) {
                int numSplits = random.nextInt(MAX_LENGTH / 20) + 1;
                LOG.debug((Object)("splitting: requesting = " + numSplits));
                InputSplit[] splits = format.getSplits(job, numSplits);
                LOG.debug((Object)("splitting: got =        " + splits.length));
                BitSet bits = new BitSet(length);
                for (int j = 0; j < splits.length; ++j) {
                    LOG.debug((Object)("split[" + j + "]= " + splits[j]));
                    RecordReader reader = format.getRecordReader(splits[j], job, reporter);
                    Class<?> readerClass = reader.getClass();
                    Assert.assertEquals((String)"reader class is KeyValueLineRecordReader.", KeyValueLineRecordReader.class, readerClass);
                    Text key = (Text)reader.createKey();
                    Class<?> keyClass = key.getClass();
                    Text value = (Text)reader.createValue();
                    Class<?> valueClass = value.getClass();
                    Assert.assertEquals((String)"Key class is Text.", Text.class, keyClass);
                    Assert.assertEquals((String)"Value class is Text.", Text.class, valueClass);
                    try {
                        int count = 0;
                        while (reader.next((Object)key, (Object)value)) {
                            int v = Integer.parseInt(value.toString());
                            LOG.debug((Object)("read " + v));
                            if (bits.get(v)) {
                                LOG.warn((Object)("conflict with " + v + " in split " + j + " at position " + reader.getPos()));
                            }
                            Assert.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(v));
                            bits.set(v);
                            ++count;
                        }
                        LOG.debug((Object)("splits[" + j + "]=" + splits[j] + " count=" + count));
                        continue;
                    }
                    finally {
                        reader.close();
                    }
                }
                Assert.assertEquals((String)"Some keys in no partition.", (long)length, (long)bits.cardinality());
            }
        }
    }

    private LineReader makeStream(String str) throws IOException {
        return new LineReader((InputStream)new ByteArrayInputStream(str.getBytes("UTF-8")), (Configuration)defaultConf);
    }

    @Test
    public void testUTF8() throws Exception {
        try (LineReader in = null;){
            in = this.makeStream("abcd\u20acbdcd\u20ac");
            Text line = new Text();
            in.readLine(line);
            Assert.assertEquals((String)"readLine changed utf8 characters", (Object)"abcd\u20acbdcd\u20ac", (Object)line.toString());
            in = this.makeStream("abc\u200axyz");
            in.readLine(line);
            Assert.assertEquals((String)"split on fake newline", (Object)"abc\u200axyz", (Object)line.toString());
        }
    }

    @Test
    public void testNewLines() throws Exception {
        try (LineReader in = null;){
            in = this.makeStream("a\nbb\n\nccc\rdddd\r\neeeee");
            Text out = new Text();
            in.readLine(out);
            Assert.assertEquals((String)"line1 length", (long)1L, (long)out.getLength());
            in.readLine(out);
            Assert.assertEquals((String)"line2 length", (long)2L, (long)out.getLength());
            in.readLine(out);
            Assert.assertEquals((String)"line3 length", (long)0L, (long)out.getLength());
            in.readLine(out);
            Assert.assertEquals((String)"line4 length", (long)3L, (long)out.getLength());
            in.readLine(out);
            Assert.assertEquals((String)"line5 length", (long)4L, (long)out.getLength());
            in.readLine(out);
            Assert.assertEquals((String)"line5 length", (long)5L, (long)out.getLength());
            Assert.assertEquals((String)"end of file", (long)0L, (long)in.readLine(out));
        }
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Text> readSplit(KeyValueTextInputFormat format, InputSplit split, JobConf job) throws IOException {
        ArrayList<Text> result = new ArrayList<Text>();
        try (RecordReader reader = null;){
            reader = format.getRecordReader(split, job, voidReporter);
            Text key = (Text)reader.createKey();
            Text value = (Text)reader.createValue();
            while (reader.next((Object)key, (Object)value)) {
                result.add(value);
                value = (Text)reader.createValue();
            }
        }
        return result;
    }

    @Test
    public void testGzip() throws IOException {
        JobConf job = new JobConf();
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)job);
        localFs.delete(workDir, true);
        TestKeyValueTextInputFormat.writeFile(localFs, new Path(workDir, "part1.txt.gz"), (CompressionCodec)gzip, "line-1\tthe quick\nline-2\tbrown\nline-3\tfox jumped\nline-4\tover\nline-5\t the lazy\nline-6\t dog\n");
        TestKeyValueTextInputFormat.writeFile(localFs, new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, "line-1\tthis is a test\nline-1\tof gzip\n");
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        KeyValueTextInputFormat format = new KeyValueTextInputFormat();
        format.configure(job);
        InputSplit[] splits = format.getSplits(job, 100);
        Assert.assertEquals((String)"compressed splits == 2", (long)2L, (long)splits.length);
        FileSplit tmp = (FileSplit)splits[0];
        if (tmp.getPath().getName().equals("part2.txt.gz")) {
            splits[0] = splits[1];
            splits[1] = tmp;
        }
        List<Text> results = TestKeyValueTextInputFormat.readSplit(format, splits[0], job);
        Assert.assertEquals((String)"splits[0] length", (long)6L, (long)results.size());
        Assert.assertEquals((String)"splits[0][5]", (Object)" dog", (Object)results.get(5).toString());
        results = TestKeyValueTextInputFormat.readSplit(format, splits[1], job);
        Assert.assertEquals((String)"splits[1] length", (long)2L, (long)results.size());
        Assert.assertEquals((String)"splits[1][0]", (Object)"this is a test", (Object)results.get(0).toString());
        Assert.assertEquals((String)"splits[1][1]", (Object)"of gzip", (Object)results.get(1).toString());
    }

    public static void main(String[] args) throws Exception {
        new TestKeyValueTextInputFormat().testFormat();
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestKeyValueTextInputFormat");
        voidReporter = Reporter.NULL;
    }
}

