/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.tools.rumen.EventType;
import org.apache.hadoop.tools.rumen.HistoryEvent;

public class JobFinishedEvent
implements HistoryEvent {
    private JobID jobId;
    private long finishTime;
    private int finishedMaps;
    private int finishedReduces;
    private int failedMaps;
    private int failedReduces;
    private Counters mapCounters;
    private Counters reduceCounters;
    private Counters totalCounters;

    public JobFinishedEvent(JobID id, long finishTime, int finishedMaps, int finishedReduces, int failedMaps, int failedReduces, Counters mapCounters, Counters reduceCounters, Counters totalCounters) {
        this.jobId = id;
        this.finishTime = finishTime;
        this.finishedMaps = finishedMaps;
        this.finishedReduces = finishedReduces;
        this.failedMaps = failedMaps;
        this.failedReduces = failedReduces;
        this.mapCounters = mapCounters;
        this.reduceCounters = reduceCounters;
        this.totalCounters = totalCounters;
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_FINISHED;
    }

    public JobID getJobid() {
        return this.jobId;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public int getFinishedMaps() {
        return this.finishedMaps;
    }

    public int getFinishedReduces() {
        return this.finishedReduces;
    }

    public int getFailedMaps() {
        return this.failedMaps;
    }

    public int getFailedReduces() {
        return this.failedReduces;
    }

    public Counters getTotalCounters() {
        return this.totalCounters;
    }

    public Counters getMapCounters() {
        return this.mapCounters;
    }

    public Counters getReduceCounters() {
        return this.reduceCounters;
    }
}

