/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.tools.rumen.LoggedLocation;

class ParsedHost {
    private final String rackName;
    private final String nodeName;
    private static final Pattern splitPattern = Pattern.compile("/([^/]+)/([^/]+)");

    static int numberOfDistances() {
        return 3;
    }

    String nameComponent(int i) throws IllegalArgumentException {
        switch (i) {
            case 0: {
                return this.rackName;
            }
            case 1: {
                return this.nodeName;
            }
        }
        throw new IllegalArgumentException("Host location component index out of range.");
    }

    public int hashCode() {
        return this.rackName.hashCode() * 17 + this.nodeName.hashCode();
    }

    public static ParsedHost parse(String name) {
        Matcher matcher = splitPattern.matcher(name);
        if (!matcher.matches()) {
            return null;
        }
        return new ParsedHost(matcher.group(1), matcher.group(2));
    }

    public ParsedHost(LoggedLocation loc) {
        List<String> coordinates = loc.getLayers();
        this.rackName = coordinates.get(0);
        this.nodeName = coordinates.get(1);
    }

    LoggedLocation makeLoggedLocation() {
        LoggedLocation result = new LoggedLocation();
        ArrayList<String> coordinates = new ArrayList<String>();
        coordinates.add(this.rackName);
        coordinates.add(this.nodeName);
        result.setLayers(coordinates);
        return result;
    }

    String getNodeName() {
        return this.nodeName;
    }

    String getRackName() {
        return this.rackName;
    }

    ParsedHost(String rackName, String nodeName) {
        this.rackName = rackName;
        this.nodeName = nodeName;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ParsedHost)) {
            return false;
        }
        ParsedHost host = (ParsedHost)other;
        return this.nodeName.equals(host.nodeName) && this.rackName.equals(host.rackName);
    }

    int distance(ParsedHost other) {
        if (this.nodeName.equals(other.nodeName)) {
            return 0;
        }
        if (this.rackName.equals(other.rackName)) {
            return 1;
        }
        return 2;
    }
}

