/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerResourceDecrease;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerResourceDecreasePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.junit.Assert;
import org.junit.Test;

public class TestContainerResourceDecrease {
    @Test
    public void testResourceDecreaseContext() {
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1234L, (int)3), (int)3), (int)7);
        Resource resource = Resource.newInstance((int)1023, (int)3);
        ContainerResourceDecrease ctx = ContainerResourceDecrease.newInstance((ContainerId)containerId, (Resource)resource);
        YarnProtos.ContainerResourceDecreaseProto proto = ((ContainerResourceDecreasePBImpl)ctx).getProto();
        ctx = new ContainerResourceDecreasePBImpl(proto);
        Assert.assertEquals((Object)ctx.getCapability(), (Object)resource);
        Assert.assertEquals((Object)ctx.getContainerId(), (Object)containerId);
    }

    @Test
    public void testResourceDecreaseContextWithNull() {
        ContainerResourceDecrease ctx = ContainerResourceDecrease.newInstance(null, null);
        YarnProtos.ContainerResourceDecreaseProto proto = ((ContainerResourceDecreasePBImpl)ctx).getProto();
        ctx = new ContainerResourceDecreasePBImpl(proto);
        Assert.assertNull((Object)ctx.getCapability());
        Assert.assertNull((Object)ctx.getContainerId());
    }
}

