/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import java.util.EnumSet;
import java.util.HashSet;
import org.apache.commons.lang.math.LongRange;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationsRequestPBImpl;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.junit.Assert;
import org.junit.Test;

public class TestGetApplicationsRequest {
    @Test
    public void testGetApplicationsRequest() {
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        EnumSet<YarnApplicationState> appStates = EnumSet.of(YarnApplicationState.ACCEPTED);
        request.setApplicationStates(appStates);
        HashSet<String> tags = new HashSet<String>();
        tags.add("tag1");
        request.setApplicationTags(tags);
        HashSet<String> types = new HashSet<String>();
        types.add("type1");
        request.setApplicationTypes(types);
        long startBegin = System.currentTimeMillis();
        long startEnd = System.currentTimeMillis() + 1L;
        request.setStartRange(startBegin, startEnd);
        long finishBegin = System.currentTimeMillis() + 2L;
        long finishEnd = System.currentTimeMillis() + 3L;
        request.setFinishRange(finishBegin, finishEnd);
        long limit = 100L;
        request.setLimit(limit);
        HashSet<String> queues = new HashSet<String>();
        queues.add("queue1");
        request.setQueues(queues);
        HashSet<String> users = new HashSet<String>();
        users.add("user1");
        request.setUsers(users);
        ApplicationsRequestScope scope = ApplicationsRequestScope.ALL;
        request.setScope(scope);
        GetApplicationsRequestPBImpl requestFromProto = new GetApplicationsRequestPBImpl(((GetApplicationsRequestPBImpl)request).getProto());
        Assert.assertEquals((String)"ApplicationStates from proto is not the same with original request", (Object)requestFromProto.getApplicationStates(), appStates);
        Assert.assertEquals((String)"ApplicationTags from proto is not the same with original request", (Object)requestFromProto.getApplicationTags(), tags);
        Assert.assertEquals((String)"ApplicationTypes from proto is not the same with original request", (Object)requestFromProto.getApplicationTypes(), types);
        Assert.assertEquals((String)"StartRange from proto is not the same with original request", (Object)requestFromProto.getStartRange(), (Object)new LongRange(startBegin, startEnd));
        Assert.assertEquals((String)"FinishRange from proto is not the same with original request", (Object)requestFromProto.getFinishRange(), (Object)new LongRange(finishBegin, finishEnd));
        Assert.assertEquals((String)"Limit from proto is not the same with original request", (long)requestFromProto.getLimit(), (long)limit);
        Assert.assertEquals((String)"Queues from proto is not the same with original request", (Object)requestFromProto.getQueues(), queues);
        Assert.assertEquals((String)"Users from proto is not the same with original request", (Object)requestFromProto.getUsers(), users);
    }
}

